/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.api.server.authentication.IdentityProvider;

public class IdentityProviderRepository {
    protected final Map<String, IdentityProvider> providersByKey = new HashMap<String, IdentityProvider>();

    public IdentityProviderRepository(List<IdentityProvider> identityProviders) {
        this.providersByKey.putAll((Map<String, IdentityProvider>)FluentIterable.from(identityProviders).uniqueIndex((Function)ToKey.INSTANCE));
    }

    public IdentityProviderRepository() {
        this.providersByKey.clear();
    }

    public IdentityProvider getEnabledByKey(String key) {
        IdentityProvider identityProvider = this.providersByKey.get(key);
        if (identityProvider != null && IsEnabledFilter.INSTANCE.apply(identityProvider)) {
            return identityProvider;
        }
        throw new IllegalArgumentException(String.format("Identity provider %s does not exist or is not enabled", key));
    }

    public List<IdentityProvider> getAllEnabledAndSorted() {
        return FluentIterable.from(this.providersByKey.values()).filter((Predicate)IsEnabledFilter.INSTANCE).toSortedList((Comparator)Ordering.natural().onResultOf((Function)ToName.INSTANCE));
    }

    private static enum ToName implements Function<IdentityProvider, String>
    {
        INSTANCE;


        public String apply(@Nonnull IdentityProvider input) {
            return input.getName();
        }
    }

    private static enum ToKey implements Function<IdentityProvider, String>
    {
        INSTANCE;


        public String apply(@Nonnull IdentityProvider input) {
            return input.getKey();
        }
    }

    private static enum IsEnabledFilter implements Predicate<IdentityProvider>
    {
        INSTANCE;


        public boolean apply(@Nonnull IdentityProvider input) {
            return input.isEnabled();
        }
    }
}

