/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.DateUtils;

public class RubyUtils {
    private RubyUtils() {
    }

    @CheckForNull
    public static List<String> toStrings(@Nullable Object o) {
        List result = null;
        if (o != null) {
            if (o instanceof List) {
                result = (List)o;
            } else if (o instanceof CharSequence) {
                result = Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)o));
            }
        }
        return result;
    }

    @CheckForNull
    public static <E extends Enum<E>> List<E> toEnums(@Nullable Object o, Class<E> enumClass) {
        if (o == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        if (o instanceof List) {
            for (String s : (List)o) {
                result.add(Enum.valueOf(enumClass, s));
            }
        } else if (o instanceof CharSequence) {
            for (String s : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)o)) {
                result.add(Enum.valueOf(enumClass, s));
            }
        } else {
            throw new IllegalArgumentException("Unsupported type: " + o.getClass());
        }
        return result;
    }

    @CheckForNull
    public static Integer toInteger(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return Ints.checkedCast((long)((Long)o));
        }
        if (o instanceof String) {
            if (StringUtils.isBlank((String)((String)o))) {
                return null;
            }
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Unsupported type for integer: " + o.getClass());
    }

    @CheckForNull
    public static Double toDouble(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            return ((Long)o).doubleValue();
        }
        if (o instanceof String) {
            if (StringUtils.isBlank((String)((String)o))) {
                return null;
            }
            return Double.parseDouble((String)o);
        }
        throw new IllegalArgumentException("Unsupported type for double: " + o.getClass());
    }

    @CheckForNull
    public static Date toDate(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            if (StringUtils.isBlank((String)((String)o))) {
                return null;
            }
            Date date = DateUtils.parseDateTimeQuietly((String)((String)o));
            if (date != null) {
                return date;
            }
            return DateUtils.parseDate((String)((String)o));
        }
        throw new IllegalArgumentException("Unsupported type for date: " + o.getClass());
    }

    @CheckForNull
    public static Boolean toBoolean(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            if (StringUtils.isBlank((String)((String)o))) {
                return null;
            }
            return Boolean.parseBoolean((String)o);
        }
        throw new IllegalArgumentException("Unsupported type for boolean: " + o.getClass());
    }

    @CheckForNull
    public static Long toLong(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            if (StringUtils.isBlank((String)((String)o))) {
                return null;
            }
            return Long.parseLong((String)o);
        }
        throw new IllegalArgumentException("Unsupported type for long: " + o.getClass());
    }
}

