/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.user.ws.UserJsonWriter;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.user.UpdateRequest;

public class UpdateAction
implements UsersWsAction {
    private final UserUpdater userUpdater;
    private final UserSession userSession;
    private final UserJsonWriter userWriter;
    private final DbClient dbClient;

    public UpdateAction(UserUpdater userUpdater, UserSession userSession, UserJsonWriter userWriter, DbClient dbClient) {
        this.userUpdater = userUpdater;
        this.userSession = userSession;
        this.userWriter = userWriter;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("update").setDescription("Update a user. If a deactivated user account exists with the given login, it will be reactivated. Requires Administer System permission").setSince("3.7").setChangelog(new Change[]{new Change("5.2", "User's password can only be changed using the 'change_password' action.")}).setPost(true).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("update-example.json"));
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"myuser");
        action.createParam("name").setDescription("User name").setExampleValue((Object)"My Name");
        action.createParam("email").setDescription("User email").setExampleValue((Object)"myname@email.com");
        action.createParam("scmAccounts").setDescription("This parameter is deprecated, please use '%s' instead", new Object[]{"scmAccount"}).setDeprecatedKey("scm_accounts", "6.0").setDeprecatedSince("6.1").setExampleValue((Object)"myscmaccount1,myscmaccount2");
        action.createParam("scmAccount").setDescription("SCM accounts. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"scmAccount=firstValue&scmAccount=secondValue&scmAccount=thirdValue");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        UpdateRequest updateRequest = UpdateAction.toWsRequest(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.doHandle(dbSession, UpdateAction.toWsRequest(request));
            this.writeUser(dbSession, response, updateRequest.getLogin());
        }
    }

    private void doHandle(DbSession dbSession, UpdateRequest request) {
        String login = request.getLogin();
        UpdateUser updateUser = UpdateUser.create(login);
        if (request.getName() != null) {
            updateUser.setName(request.getName());
        }
        if (request.getEmail() != null) {
            updateUser.setEmail(Strings.emptyToNull((String)request.getEmail()));
        }
        if (!request.getScmAccounts().isEmpty()) {
            updateUser.setScmAccounts(request.getScmAccounts());
        }
        this.userUpdater.updateAndCommit(dbSession, updateUser, u -> {});
    }

    private void writeUser(DbSession dbSession, Response response, String login) {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject();
            json.name("user");
            HashSet<String> groups = new HashSet<String>();
            UserDto user = WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' doesn't exist", login);
            groups.addAll(this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(login)).get((Object)login));
            this.userWriter.write(json, user, groups, UserJsonWriter.FIELDS);
            json.endObject().close();
        }
    }

    private static UpdateRequest toWsRequest(Request request) {
        return UpdateRequest.builder().setLogin(request.mandatoryParam("login")).setName(request.param("name")).setEmail(request.param("email")).setScmAccounts(UpdateAction.getScmAccounts(request)).build();
    }

    private static List<String> getScmAccounts(Request request) {
        if (request.hasParam("scmAccount")) {
            return new ArrayList<String>(request.multiParam("scmAccount"));
        }
        List oldScmAccounts = request.paramAsStrings("scmAccounts");
        return oldScmAccounts != null ? oldScmAccounts : new ArrayList();
    }
}

