/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import java.util.Map;
import java.util.Objects;
import org.sonar.server.measure.index.ProjectMeasuresStatistics;

public class TelemetryData {
    private final String serverId;
    private final String version;
    private final Map<String, String> plugins;
    private final long lines;
    private final long ncloc;
    private final long userCount;
    private final long projectCount;
    private final boolean usingBranches;
    private final Database database;
    private final Map<String, Long> projectCountByLanguage;
    private final Map<String, Long> nclocByLanguage;

    private TelemetryData(Builder builder) {
        this.serverId = builder.serverId;
        this.version = builder.version;
        this.plugins = builder.plugins;
        this.lines = builder.projectMeasuresStatistics.getLines();
        this.ncloc = builder.projectMeasuresStatistics.getNcloc();
        this.userCount = builder.userCount;
        this.projectCount = builder.projectMeasuresStatistics.getProjectCount();
        this.usingBranches = builder.usingBranches;
        this.database = builder.database;
        this.projectCountByLanguage = builder.projectMeasuresStatistics.getProjectCountByLanguage();
        this.nclocByLanguage = builder.projectMeasuresStatistics.getNclocByLanguage();
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    public long getLines() {
        return this.lines;
    }

    public long getNcloc() {
        return this.ncloc;
    }

    public long getUserCount() {
        return this.userCount;
    }

    public long getProjectCount() {
        return this.projectCount;
    }

    public boolean isUsingBranches() {
        return this.usingBranches;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Map<String, Long> getProjectCountByLanguage() {
        return this.projectCountByLanguage;
    }

    public Map<String, Long> getNclocByLanguage() {
        return this.nclocByLanguage;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Database {
        private final String name;
        private final String version;

        Database(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }

    static class Builder {
        private String serverId;
        private String version;
        private long userCount;
        private Map<String, String> plugins;
        private Database database;
        private ProjectMeasuresStatistics projectMeasuresStatistics;
        private Boolean usingBranches;

        private Builder() {
        }

        Builder setServerId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        void setUserCount(long userCount) {
            this.userCount = userCount;
        }

        void setPlugins(Map<String, String> plugins) {
            this.plugins = plugins;
        }

        void setProjectMeasuresStatistics(ProjectMeasuresStatistics projectMeasuresStatistics) {
            this.projectMeasuresStatistics = projectMeasuresStatistics;
        }

        Builder setDatabase(Database database) {
            this.database = database;
            return this;
        }

        Builder setUsingBranches(boolean usingBranches) {
            this.usingBranches = usingBranches;
            return this;
        }

        TelemetryData build() {
            Objects.requireNonNull(this.serverId);
            Objects.requireNonNull(this.version);
            Objects.requireNonNull(this.plugins);
            Objects.requireNonNull(this.projectMeasuresStatistics);
            Objects.requireNonNull(this.database);
            Objects.requireNonNull(this.usingBranches);
            return new TelemetryData(this);
        }
    }
}

