/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.source.SourceService;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;

public class RawAction
implements SourcesWsAction {
    private final DbClient dbClient;
    private final SourceService sourceService;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public RawAction(DbClient dbClient, SourceService sourceService, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.sourceService = sourceService;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("raw").setDescription("Get source code as raw text. Require 'See Source Code' permission on file").setSince("5.0").setResponseExample(Resources.getResource(this.getClass(), (String)"example-raw.txt")).setHandler((RequestHandler)this);
        action.createParam("key").setRequired(true).setDescription("File key").setExampleValue((Object)"my_project:src/foo/Bar.php");
        action.createParam("branch").setDescription("Branch key").setInternal(true).setExampleValue((Object)"feature/my_branch");
    }

    public void handle(Request request, Response response) {
        String fileKey = request.mandatoryParam("key");
        String branch = request.param("branch");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto file = this.componentFinder.getByKeyAndOptionalBranch(dbSession, fileKey, branch);
            this.userSession.checkComponentPermission("codeviewer", file);
            Optional<Iterable<String>> lines = this.sourceService.getLinesAsRawText(dbSession, file.uuid(), 1, Integer.MAX_VALUE);
            response.stream().setMediaType("text/plain");
            if (lines.isPresent()) {
                OutputStream output = response.stream().output();
                for (String line : lines.get()) {
                    output.write(line.getBytes(StandardCharsets.UTF_8));
                    output.write("\n".getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to write raw source of file " + fileKey, e);
        }
    }
}

