/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.source.CharactersReader;
import org.sonar.server.source.DecorationDataHolder;

class HtmlTextDecorator {
    static final char CR_END_OF_LINE = '\r';
    static final char LF_END_OF_LINE = '\n';
    static final char HTML_OPENING = '<';
    static final char HTML_CLOSING = '>';
    static final char AMPERSAND = '&';
    static final String ENCODED_HTML_OPENING = "&lt;";
    static final String ENCODED_HTML_CLOSING = "&gt;";
    static final String ENCODED_AMPERSAND = "&amp;";

    HtmlTextDecorator() {
    }

    List<String> decorateTextWithHtml(String text, DecorationDataHolder decorationDataHolder) {
        return this.decorateTextWithHtml(text, decorationDataHolder, null, null);
    }

    List<String> decorateTextWithHtml(String text, DecorationDataHolder decorationDataHolder, @Nullable Integer from, @Nullable Integer to) {
        StringBuilder currentHtmlLine = new StringBuilder();
        ArrayList decoratedHtmlLines = Lists.newArrayList();
        int currentLine = 1;
        BufferedReader stringBuffer = null;
        try {
            stringBuffer = new BufferedReader(new StringReader(text));
            CharactersReader charsReader = new CharactersReader(stringBuffer);
            while (charsReader.readNextChar() && !HtmlTextDecorator.shouldStop(currentLine, to)) {
                if (this.shouldStartNewLine(charsReader)) {
                    if (HtmlTextDecorator.canAddLine(currentLine, from)) {
                        decoratedHtmlLines.add(currentHtmlLine.toString());
                    }
                    ++currentLine;
                    currentHtmlLine = new StringBuilder();
                }
                this.addCharToCurrentLine(charsReader, currentHtmlLine, decorationDataHolder);
            }
            this.closeCurrentSyntaxTags(charsReader, currentHtmlLine);
            if (this.shouldStartNewLine(charsReader)) {
                HtmlTextDecorator.addLine(decoratedHtmlLines, currentHtmlLine.toString(), currentLine, from, to);
                HtmlTextDecorator.addLine(decoratedHtmlLines, "", ++currentLine, from, to);
            } else if (currentHtmlLine.length() > 0) {
                HtmlTextDecorator.addLine(decoratedHtmlLines, currentHtmlLine.toString(), currentLine, from, to);
            }
        }
        catch (IOException exception) {
            try {
                String errorMsg = "An exception occurred while highlighting the syntax of one of the project's files";
                Loggers.get(HtmlTextDecorator.class).error(errorMsg);
                throw new IllegalStateException(errorMsg, exception);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stringBuffer);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)stringBuffer);
        return decoratedHtmlLines;
    }

    private void addCharToCurrentLine(CharactersReader charsReader, StringBuilder currentHtmlLine, DecorationDataHolder decorationDataHolder) {
        if (this.shouldStartNewLine(charsReader) && this.shouldReopenPendingTags(charsReader)) {
            this.reopenCurrentSyntaxTags(charsReader, currentHtmlLine);
        }
        int numberOfTagsToClose = this.getNumberOfTagsToClose(charsReader.getCurrentIndex(), decorationDataHolder);
        this.closeCompletedTags(charsReader, numberOfTagsToClose, currentHtmlLine);
        if (this.shouldClosePendingTags(charsReader)) {
            this.closeCurrentSyntaxTags(charsReader, currentHtmlLine);
        }
        Collection<String> tagsToOpen = this.getTagsToOpen(charsReader.getCurrentIndex(), decorationDataHolder);
        this.openNewTags(charsReader, tagsToOpen, currentHtmlLine);
        if (this.shouldAppendCharToHtmlOutput(charsReader)) {
            char currentChar = (char)charsReader.getCurrentValue();
            currentHtmlLine.append(this.normalize(currentChar));
        }
    }

    private static void addLine(List<String> decoratedHtmlLines, String line, int currentLine, @Nullable Integer from, @Nullable Integer to) {
        if (HtmlTextDecorator.canAddLine(currentLine, from) && !HtmlTextDecorator.shouldStop(currentLine, to)) {
            decoratedHtmlLines.add(line);
        }
    }

    private static boolean canAddLine(int currentLine, @Nullable Integer from) {
        return from == null || currentLine >= from;
    }

    private static boolean shouldStop(int currentLine, @Nullable Integer to) {
        return to != null && to < currentLine;
    }

    private char[] normalize(char currentChar) {
        char[] normalizedChars = currentChar == '<' ? ENCODED_HTML_OPENING.toCharArray() : (currentChar == '>' ? ENCODED_HTML_CLOSING.toCharArray() : (currentChar == '&' ? ENCODED_AMPERSAND.toCharArray() : new char[]{currentChar}));
        return normalizedChars;
    }

    private boolean shouldAppendCharToHtmlOutput(CharactersReader charsReader) {
        return charsReader.getCurrentValue() != 13 && charsReader.getCurrentValue() != 10;
    }

    private int getNumberOfTagsToClose(int currentIndex, DecorationDataHolder dataHolder) {
        int numberOfTagsToClose = 0;
        while (currentIndex == dataHolder.getCurrentClosingTagOffset()) {
            ++numberOfTagsToClose;
            dataHolder.nextClosingTagOffset();
        }
        return numberOfTagsToClose;
    }

    private Collection<String> getTagsToOpen(int currentIndex, DecorationDataHolder dataHolder) {
        ArrayList tagsToOpen = Lists.newArrayList();
        while (dataHolder.getCurrentOpeningTagEntry() != null && currentIndex == dataHolder.getCurrentOpeningTagEntry().getStartOffset()) {
            tagsToOpen.add(dataHolder.getCurrentOpeningTagEntry().getCssClass());
            dataHolder.nextOpeningTagEntry();
        }
        return tagsToOpen;
    }

    private boolean shouldClosePendingTags(CharactersReader charactersReader) {
        return charactersReader.getCurrentValue() == 13 || charactersReader.getCurrentValue() == 10 && charactersReader.getPreviousValue() != 13 || charactersReader.getCurrentValue() == -1 && charactersReader.getPreviousValue() != 10;
    }

    private boolean shouldReopenPendingTags(CharactersReader charactersReader) {
        return charactersReader.getPreviousValue() == 10 && charactersReader.getCurrentValue() != 10 || charactersReader.getPreviousValue() == 13 && charactersReader.getCurrentValue() != 13 && charactersReader.getCurrentValue() != 10;
    }

    private boolean shouldStartNewLine(CharactersReader charactersReader) {
        return charactersReader.getPreviousValue() == 10 || charactersReader.getPreviousValue() == 13 && charactersReader.getCurrentValue() != 10;
    }

    private void closeCompletedTags(CharactersReader charactersReader, int numberOfTagsToClose, StringBuilder decoratedText) {
        for (int i = 0; i < numberOfTagsToClose; ++i) {
            this.injectClosingHtml(decoratedText);
            charactersReader.removeLastOpenTag();
        }
    }

    private void openNewTags(CharactersReader charactersReader, Collection<String> tagsToOpen, StringBuilder decoratedText) {
        for (String tagToOpen : tagsToOpen) {
            this.injectOpeningHtmlForRule(tagToOpen, decoratedText);
            charactersReader.registerOpenTag(tagToOpen);
        }
    }

    private void closeCurrentSyntaxTags(CharactersReader charactersReader, StringBuilder decoratedText) {
        for (int i = 0; i < charactersReader.getOpenTags().size(); ++i) {
            this.injectClosingHtml(decoratedText);
        }
    }

    private void reopenCurrentSyntaxTags(CharactersReader charactersReader, StringBuilder decoratedText) {
        for (String tags : charactersReader.getOpenTags()) {
            this.injectOpeningHtmlForRule(tags, decoratedText);
        }
    }

    private void injectOpeningHtmlForRule(String textType, StringBuilder decoratedText) {
        decoratedText.append("<span class=\"").append(textType).append("\">");
    }

    private void injectClosingHtml(StringBuilder decoratedText) {
        decoratedText.append("</span>");
    }
}

