/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleWsSupport {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public RuleWsSupport(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void checkQProfileAdminPermissionOnDefaultOrganization() {
        this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, this.defaultOrganizationProvider.get().getUuid());
    }

    public OrganizationDto getOrganizationByKey(DbSession dbSession, @Nullable String organizationKey) {
        String organizationOrDefaultKey = Optional.ofNullable(organizationKey).orElseGet(this.defaultOrganizationProvider.get()::getKey);
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationOrDefaultKey), "No organization with key '%s'", organizationOrDefaultKey);
    }
}

