/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.io.Resources;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleRepositoryDto;
import org.sonar.server.rule.ws.RulesWsAction;

public class RepositoriesAction
implements RulesWsAction {
    private static final String LANGUAGE = "language";
    private static final String MATCH_ALL = ".*";
    private final DbClient dbClient;

    public RepositoriesAction(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("repositories").setDescription("List available rule repositories").setSince("4.5").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-repositories.json"));
        action.createParam("q").setDescription("A pattern to match repository keys/names against").setExampleValue((Object)"squid");
        action.createParam(LANGUAGE).setDescription("A language key; if provided, only repositories for the given language will be returned").setExampleValue((Object)"java");
    }

    public void handle(Request request, Response response) throws Exception {
        String query = request.param("q");
        String languageKey = request.param(LANGUAGE);
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("repositories").beginArray();
            for (RuleRepositoryDto repo : this.listMatchingRepositories(query, languageKey)) {
                json.beginObject().prop("key", repo.getKey()).prop("name", repo.getName()).prop(LANGUAGE, repo.getLanguage()).endObject();
            }
            json.endArray().endObject();
        }
    }

    private Collection<RuleRepositoryDto> listMatchingRepositories(@Nullable String query, @Nullable String languageKey) {
        Pattern pattern = Pattern.compile(query == null ? MATCH_ALL : MATCH_ALL + Pattern.quote(query) + MATCH_ALL, 2);
        return (Collection)this.selectFromDb(languageKey).stream().filter(r -> pattern.matcher(r.getKey()).matches() || pattern.matcher(r.getName()).matches()).collect(MoreCollectors.toList());
    }

    private Collection<RuleRepositoryDto> selectFromDb(@Nullable String language) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (StringUtils.isEmpty((String)language)) {
                List list = this.dbClient.ruleRepositoryDao().selectAll(dbSession);
                return list;
            }
            List list = this.dbClient.ruleRepositoryDao().selectByLanguage(dbSession, language);
            return list;
        }
    }
}

