/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.server.qualityprofile.QProfileName;

@Immutable
public final class BuiltInQProfile {
    private final QProfileName qProfileName;
    private final boolean isDefault;
    private final List<BuiltInQualityProfilesDefinition.BuiltInActiveRule> activeRules;

    private BuiltInQProfile(Builder builder) {
        this.qProfileName = new QProfileName(builder.language, builder.name);
        this.isDefault = builder.declaredDefault || builder.computedDefault;
        this.activeRules = ImmutableList.copyOf((Collection)builder.activeRules);
    }

    public String getName() {
        return this.qProfileName.getName();
    }

    public String getLanguage() {
        return this.qProfileName.getLanguage();
    }

    public QProfileName getQProfileName() {
        return this.qProfileName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public List<BuiltInQualityProfilesDefinition.BuiltInActiveRule> getActiveRules() {
        return this.activeRules;
    }

    static final class Builder {
        private String language;
        private String name;
        private boolean declaredDefault;
        private boolean computedDefault;
        private final List<BuiltInQualityProfilesDefinition.BuiltInActiveRule> activeRules = new ArrayList<BuiltInQualityProfilesDefinition.BuiltInActiveRule>();

        Builder() {
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        String getName() {
            return this.name;
        }

        Builder setDeclaredDefault(boolean declaredDefault) {
            this.declaredDefault = declaredDefault;
            return this;
        }

        boolean isDeclaredDefault() {
            return this.declaredDefault;
        }

        Builder setComputedDefault(boolean flag) {
            this.computedDefault = flag;
            return this;
        }

        Builder addRules(List<BuiltInQualityProfilesDefinition.BuiltInActiveRule> rules) {
            this.activeRules.addAll(rules);
            return this;
        }

        BuiltInQProfile build() {
            return new BuiltInQProfile(this);
        }
    }
}

