/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.io.Resources;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.qualitygate.ProjectQgateAssociation;
import org.sonar.db.qualitygate.ProjectQgateAssociationQuery;
import org.sonar.server.qualitygate.QgateProjectFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;

public class SearchAction
implements QualityGatesWsAction {
    private final QgateProjectFinder projectFinder;

    public SearchAction(QgateProjectFinder projectFinder) {
        this.projectFinder = projectFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("search").setDescription("Search for projects associated (or not) to a quality gate.<br/>Only authorized projects for current user will be returned.").setSince("4.3").setResponseExample(Resources.getResource(this.getClass(), (String)"example-search.json")).setHandler((RequestHandler)this);
        action.createParam("gateId").setDescription("Quality Gate ID").setRequired(true).setExampleValue((Object)"1");
        action.createParam("query").setDescription("To search for projects containing this string. If this parameter is set, \"selected\" is set to \"all\".").setExampleValue((Object)"abc");
        action.addSelectionModeParam();
        action.createParam("page").setDescription("Page number").setDefaultValue((Object)"1").setExampleValue((Object)"2");
        action.createParam("pageSize").setDescription("Page size").setExampleValue((Object)"10");
    }

    public void handle(Request request, Response response) {
        QgateProjectFinder.Association associations = this.projectFinder.find(ProjectQgateAssociationQuery.builder().gateId(request.mandatoryParam("gateId")).membership(request.param("query") == null ? request.param("selected") : "all").projectSearch(request.param("query")).pageIndex(request.paramAsInt("page")).pageSize(request.paramAsInt("pageSize")).build());
        try (JsonWriter writer = response.newJsonWriter();){
            writer.beginObject().prop("more", associations.hasMoreResults());
            writer.name("results").beginArray();
            for (ProjectQgateAssociation project : associations.projects()) {
                writer.beginObject().prop("id", (Number)project.id()).prop("name", project.name()).prop("selected", project.isMember()).endObject();
            }
            writer.endArray().endObject().close();
        }
    }
}

