/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGates;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;

public class RenameAction
implements QualityGatesWsAction {
    private final QualityGates qualityGates;

    public RenameAction(QualityGates qualityGates) {
        this.qualityGates = qualityGates;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("rename").setDescription("Rename a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("id").setDescription("ID of the quality gate to rename").setRequired(true).setExampleValue((Object)"1");
        action.createParam("name").setDescription("New name of the quality gate").setRequired(true).setExampleValue((Object)"My Quality Gate");
    }

    public void handle(Request request, Response response) {
        long idToRename = QualityGatesWs.parseId(request, "id");
        QualityGateDto renamedQualityGate = this.qualityGates.rename(idToRename, request.mandatoryParam("name"));
        JsonWriter writer = response.newJsonWriter();
        QualityGatesWs.writeQualityGate(renamedQualityGate, writer).close();
    }
}

