/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.component.SnapshotDto;
import org.sonarqube.ws.WsQualityGates;

public class QualityGateDetailsFormatter {
    private final Optional<String> optionalMeasureData;
    private final Optional<SnapshotDto> optionalSnapshot;
    private final WsQualityGates.ProjectStatusWsResponse.ProjectStatus.Builder projectStatusBuilder;

    public QualityGateDetailsFormatter(Optional<String> measureData, Optional<SnapshotDto> snapshot) {
        this.optionalMeasureData = measureData;
        this.optionalSnapshot = snapshot;
        this.projectStatusBuilder = WsQualityGates.ProjectStatusWsResponse.ProjectStatus.newBuilder();
    }

    public WsQualityGates.ProjectStatusWsResponse.ProjectStatus format() {
        if (!this.optionalMeasureData.isPresent()) {
            return QualityGateDetailsFormatter.newResponseWithoutQualityGateDetails();
        }
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse((String)this.optionalMeasureData.get()).getAsJsonObject();
        WsQualityGates.ProjectStatusWsResponse.Status qualityGateStatus = QualityGateDetailsFormatter.measureLevelToQualityGateStatus(json.get("level").getAsString());
        this.projectStatusBuilder.setStatus(qualityGateStatus);
        this.formatIgnoredConditions(json);
        this.formatConditions(json.getAsJsonArray("conditions"));
        this.formatPeriods();
        return this.projectStatusBuilder.build();
    }

    private void formatIgnoredConditions(JsonObject json) {
        JsonElement ignoredConditions = json.get("ignoredConditions");
        if (ignoredConditions != null) {
            this.projectStatusBuilder.setIgnoredConditions(ignoredConditions.getAsBoolean());
        } else {
            this.projectStatusBuilder.setIgnoredConditions(false);
        }
    }

    private void formatPeriods() {
        String periodModeParameter;
        if (!this.optionalSnapshot.isPresent()) {
            return;
        }
        WsQualityGates.ProjectStatusWsResponse.Period.Builder periodBuilder = WsQualityGates.ProjectStatusWsResponse.Period.newBuilder();
        periodBuilder.clear();
        SnapshotDto snapshot = (SnapshotDto)this.optionalSnapshot.get();
        String periodMode = snapshot.getPeriodMode();
        if (Strings.isNullOrEmpty((String)periodMode)) {
            return;
        }
        periodBuilder.setIndex(1);
        periodBuilder.setMode(snapshot.getPeriodMode());
        Long periodDate = snapshot.getPeriodDate();
        if (periodDate != null) {
            periodBuilder.setDate(DateUtils.formatDateTime((long)periodDate));
        }
        if (!Strings.isNullOrEmpty((String)(periodModeParameter = snapshot.getPeriodModeParameter()))) {
            periodBuilder.setParameter(periodModeParameter);
        }
        this.projectStatusBuilder.addPeriods(periodBuilder);
    }

    private void formatConditions(@Nullable JsonArray jsonConditions) {
        if (jsonConditions == null) {
            return;
        }
        StreamSupport.stream(jsonConditions.spliterator(), false).map(JsonElement::getAsJsonObject).filter(QualityGateDetailsFormatter.isConditionOnValidPeriod()).forEach(this::formatCondition);
    }

    private void formatCondition(JsonObject jsonCondition) {
        WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder = WsQualityGates.ProjectStatusWsResponse.Condition.newBuilder();
        QualityGateDetailsFormatter.formatConditionLevel(conditionBuilder, jsonCondition);
        QualityGateDetailsFormatter.formatConditionMetric(conditionBuilder, jsonCondition);
        QualityGateDetailsFormatter.formatConditionOperation(conditionBuilder, jsonCondition);
        QualityGateDetailsFormatter.formatConditionPeriod(conditionBuilder, jsonCondition);
        QualityGateDetailsFormatter.formatConditionWarningThreshold(conditionBuilder, jsonCondition);
        QualityGateDetailsFormatter.formatConditionErrorThreshold(conditionBuilder, jsonCondition);
        QualityGateDetailsFormatter.formatConditionActual(conditionBuilder, jsonCondition);
        this.projectStatusBuilder.addConditions(conditionBuilder);
    }

    private static void formatConditionActual(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement actual = jsonCondition.get("actual");
        if (actual != null && !Strings.isNullOrEmpty((String)actual.getAsString())) {
            conditionBuilder.setActualValue(actual.getAsString());
        }
    }

    private static void formatConditionErrorThreshold(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement error = jsonCondition.get("error");
        if (error != null && !Strings.isNullOrEmpty((String)error.getAsString())) {
            conditionBuilder.setErrorThreshold(error.getAsString());
        }
    }

    private static void formatConditionWarningThreshold(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement warning = jsonCondition.get("warning");
        if (warning != null && !Strings.isNullOrEmpty((String)warning.getAsString())) {
            conditionBuilder.setWarningThreshold(warning.getAsString());
        }
    }

    private static void formatConditionPeriod(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement periodIndex = jsonCondition.get("period");
        if (periodIndex == null) {
            return;
        }
        conditionBuilder.setPeriodIndex(periodIndex.getAsInt());
    }

    private static void formatConditionOperation(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement op = jsonCondition.get("op");
        if (op != null && !Strings.isNullOrEmpty((String)op.getAsString())) {
            String stringOp = op.getAsString();
            WsQualityGates.ProjectStatusWsResponse.Comparator comparator = QualityGateDetailsFormatter.measureOpToQualityGateComparator(stringOp);
            conditionBuilder.setComparator(comparator);
        }
    }

    private static void formatConditionMetric(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement metric = jsonCondition.get("metric");
        if (metric != null && !Strings.isNullOrEmpty((String)metric.getAsString())) {
            conditionBuilder.setMetricKey(metric.getAsString());
        }
    }

    private static void formatConditionLevel(WsQualityGates.ProjectStatusWsResponse.Condition.Builder conditionBuilder, JsonObject jsonCondition) {
        JsonElement measureLevel = jsonCondition.get("level");
        if (measureLevel != null && !Strings.isNullOrEmpty((String)measureLevel.getAsString())) {
            conditionBuilder.setStatus(QualityGateDetailsFormatter.measureLevelToQualityGateStatus(measureLevel.getAsString()));
        }
    }

    private static WsQualityGates.ProjectStatusWsResponse.Status measureLevelToQualityGateStatus(String measureLevel) {
        for (WsQualityGates.ProjectStatusWsResponse.Status status : WsQualityGates.ProjectStatusWsResponse.Status.values()) {
            if (!status.name().equals(measureLevel)) continue;
            return status;
        }
        throw new IllegalStateException(String.format("Unknown quality gate status '%s'", measureLevel));
    }

    private static WsQualityGates.ProjectStatusWsResponse.Comparator measureOpToQualityGateComparator(String measureOp) {
        for (WsQualityGates.ProjectStatusWsResponse.Comparator comparator : WsQualityGates.ProjectStatusWsResponse.Comparator.values()) {
            if (!comparator.name().equals(measureOp)) continue;
            return comparator;
        }
        throw new IllegalStateException(String.format("Unknown quality gate comparator '%s'", measureOp));
    }

    private static WsQualityGates.ProjectStatusWsResponse.ProjectStatus newResponseWithoutQualityGateDetails() {
        return WsQualityGates.ProjectStatusWsResponse.ProjectStatus.newBuilder().setStatus(WsQualityGates.ProjectStatusWsResponse.Status.NONE).build();
    }

    private static Predicate<JsonObject> isConditionOnValidPeriod() {
        return jsonCondition -> {
            JsonElement periodIndex = jsonCondition.get("period");
            if (periodIndex == null) {
                return true;
            }
            int period = periodIndex.getAsInt();
            return period == 1;
        };
    }
}

