/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.io.Resources;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGates;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;

public class ListAction
implements QualityGatesWsAction {
    private final QualityGates qualityGates;

    public ListAction(QualityGates qualityGates) {
        this.qualityGates = qualityGates;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("list").setDescription("Get a list of quality gates").setSince("4.3").setResponseExample(Resources.getResource(this.getClass(), (String)"example-list.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) {
        try (JsonWriter writer = response.newJsonWriter();){
            writer.beginObject().name("qualitygates").beginArray();
            for (QualityGateDto qgate : this.qualityGates.list()) {
                QualityGatesWs.writeQualityGate(qgate, writer);
            }
            writer.endArray();
            QualityGateDto defaultQgate = this.qualityGates.getDefault();
            if (defaultQgate != null) {
                writer.prop("default", (Number)defaultQgate.getId());
            }
            writer.endObject().close();
        }
    }
}

