/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGates;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;

public class CopyAction
implements QualityGatesWsAction {
    private final QualityGates qualityGates;

    public CopyAction(QualityGates qualityGates) {
        this.qualityGates = qualityGates;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("copy").setDescription("Copy a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        action.createParam("id").setDescription("The ID of the source quality gate").setRequired(true).setExampleValue((Object)"1");
        action.createParam("name").setDescription("The name of the quality gate to create").setRequired(true).setExampleValue((Object)"My Quality Gate");
    }

    public void handle(Request request, Response response) {
        QualityGateDto newQualityGate = this.qualityGates.copy(QualityGatesWs.parseId(request, "id"), request.mandatoryParam("name"));
        JsonWriter writer = response.newJsonWriter();
        QualityGatesWs.writeQualityGate(newQualityGate, writer).close();
    }
}

