/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.exceptions.NotFoundException;

public class QualityGateFinder {
    private final DbClient dbClient;

    public QualityGateFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public Optional<QualityGateData> getQualityGate(DbSession dbSession, long componentId) {
        Optional qualityGateId = this.dbClient.projectQgateAssociationDao().selectQGateIdByComponentId(dbSession, componentId);
        if (qualityGateId.isPresent()) {
            return Optional.of(new QualityGateData(this.selectOrFailById(dbSession, (Long)qualityGateId.get()), false));
        }
        QualityGateDto defaultQualityGate = this.getDefault(dbSession);
        if (defaultQualityGate == null) {
            return Optional.empty();
        }
        return Optional.of(new QualityGateData(defaultQualityGate, true));
    }

    @CheckForNull
    private QualityGateDto getDefault(DbSession dbSession) {
        Long defaultId = this.getDefaultId(dbSession);
        if (defaultId == null) {
            return null;
        }
        return this.selectOrFailById(dbSession, defaultId);
    }

    private QualityGateDto selectOrFailById(DbSession dbSession, long qualityGateId) {
        QualityGateDto qualityGateDto = this.dbClient.qualityGateDao().selectById(dbSession, qualityGateId);
        if (qualityGateDto == null) {
            throw new NotFoundException(String.format("No quality gate has been found for id %s", qualityGateId));
        }
        return qualityGateDto;
    }

    @CheckForNull
    private Long getDefaultId(DbSession dbSession) {
        PropertyDto defaultQgate = this.dbClient.propertiesDao().selectGlobalProperty(dbSession, "sonar.qualitygate");
        if (defaultQgate == null || StringUtils.isBlank((String)defaultQgate.getValue())) {
            return null;
        }
        return Long.valueOf(defaultQgate.getValue());
    }

    public static class QualityGateData {
        private final QualityGateDto qualityGate;
        private final boolean isDefault;

        private QualityGateData(QualityGateDto qualityGate, boolean isDefault) {
            this.qualityGate = qualityGate;
            this.isDefault = isDefault;
        }

        public QualityGateDto getQualityGate() {
            return this.qualityGate;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

