/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectlink.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentLinkDto;
import org.sonar.server.projectlink.ws.ProjectLinksWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.projectlinks.DeleteWsRequest;

public class DeleteAction
implements ProjectLinksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setDescription("Delete existing project link.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setHandler((RequestHandler)this).setPost(true).setSince("6.1");
        action.createParam("id").setRequired(true).setDescription("Link id").setExampleValue((Object)"17");
    }

    public void handle(Request request, Response response) throws Exception {
        DeleteWsRequest deleteWsRequest = DeleteAction.toDeleteWsRequest(request);
        this.doHandle(deleteWsRequest);
        response.noContent();
    }

    private static DeleteWsRequest toDeleteWsRequest(Request request) {
        return new DeleteWsRequest().setId(Long.valueOf(request.mandatoryParamAsLong("id")));
    }

    private void doHandle(DeleteWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            long id = request.getId();
            ComponentLinkDto link = this.dbClient.componentLinkDao().selectById(dbSession, id);
            link = WsUtils.checkFound(link, "Link with id '%s' not found", id);
            this.checkProjectAdminPermission(link);
            DeleteAction.checkNotProvided(link);
            this.dbClient.componentLinkDao().delete(dbSession, link.getId().longValue());
            dbSession.commit();
        }
    }

    private static void checkNotProvided(ComponentLinkDto link) {
        String type = link.getType();
        boolean isProvided = type != null && ComponentLinkDto.PROVIDED_TYPES.contains(type);
        WsUtils.checkRequest(!isProvided, "Provided link cannot be deleted.", new Object[0]);
    }

    private void checkProjectAdminPermission(ComponentLinkDto link) {
        this.userSession.checkComponentUuidPermission("admin", link.getComponentUuid());
    }
}

