/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.plugins.PluginDownloader;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.updatecenter.common.PluginUpdate;
import org.sonar.updatecenter.common.UpdateCenter;

public class UpdateAction
implements PluginsWsAction {
    public static final String PARAM_KEY = "key";
    public static final PluginUpdate MISSING_PLUGIN = null;
    private final UpdateCenterMatrixFactory updateCenterFactory;
    private final PluginDownloader pluginDownloader;
    private final UserSession userSession;

    public UpdateAction(UpdateCenterMatrixFactory updateCenterFactory, PluginDownloader pluginDownloader, UserSession userSession) {
        this.updateCenterFactory = updateCenterFactory;
        this.pluginDownloader = pluginDownloader;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("update").setPost(true).setSince("5.2").setDescription("Updates a plugin specified by its key to the latest version compatible with the SonarQube instance.<br/>Plugin information is retrieved from Update Center.<br/>Requires user to be authenticated with Administer System permissions").setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setDescription("The key identifying the plugin to update");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        String key = request.mandatoryParam(PARAM_KEY);
        PluginUpdate pluginUpdate = this.findPluginUpdateByKey(key);
        this.pluginDownloader.download(key, pluginUpdate.getRelease().getVersion());
        response.noContent();
    }

    @Nonnull
    private PluginUpdate findPluginUpdateByKey(String key) {
        Optional<UpdateCenter> updateCenter = this.updateCenterFactory.getUpdateCenter(false);
        PluginUpdate pluginUpdate = MISSING_PLUGIN;
        if (updateCenter.isPresent()) {
            pluginUpdate = (PluginUpdate)Iterables.find((Iterable)((UpdateCenter)updateCenter.get()).findPluginUpdates(), (Predicate)new PluginKeyPredicate(key), (Object)MISSING_PLUGIN);
        }
        if (pluginUpdate == MISSING_PLUGIN) {
            throw new IllegalArgumentException(String.format("No plugin with key '%s' or plugin '%s' is already in latest compatible version", key, key));
        }
        return pluginUpdate;
    }

    private static class PluginKeyPredicate
    implements Predicate<PluginUpdate> {
        private final String key;

        public PluginKeyPredicate(String key) {
            this.key = key;
        }

        public boolean apply(@Nullable PluginUpdate input) {
            return input != null && this.key.equals(input.getPlugin().getKey());
        }
    }
}

