/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.Resources;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.platform.PluginInfo;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.plugin.PluginDto;
import org.sonar.server.plugins.ServerPluginRepository;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginWSCommons;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.updatecenter.common.Plugin;

public class InstalledAction
implements PluginsWsAction {
    private static final String ARRAY_PLUGINS = "plugins";
    private static final String FIELD_CATEGORY = "category";
    private final ServerPluginRepository pluginRepository;
    private final PluginWSCommons pluginWSCommons;
    private final UpdateCenterMatrixFactory updateCenterMatrixFactory;
    private final DbClient dbClient;

    public InstalledAction(ServerPluginRepository pluginRepository, PluginWSCommons pluginWSCommons, UpdateCenterMatrixFactory updateCenterMatrixFactory, DbClient dbClient) {
        this.pluginRepository = pluginRepository;
        this.pluginWSCommons = pluginWSCommons;
        this.updateCenterMatrixFactory = updateCenterMatrixFactory;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("installed").setDescription("Get the list of all the plugins installed on the SonarQube instance, sorted by plugin name.").setSince("5.2").setChangelog(new Change[]{new Change("6.6", "The 'filename' field is added"), new Change("6.6", "The 'fileHash' field is added"), new Change("6.6", "The 'sonarLintSupported' field is added"), new Change("6.6", "The 'updatedAt' field is added")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-installed_plugins.json"));
        action.createFieldsParam(Collections.singleton(FIELD_CATEGORY)).setDescription(String.format("Comma-separated list of the additional fields to be returned in response. No additional field is returned by default. Possible values are:<ul><li>%s - category as defined in the Update Center. A connection to the Update Center is needed</li></lu>", FIELD_CATEGORY)).setSince("5.6");
    }

    public void handle(Request request, Response response) throws Exception {
        Map<String, PluginDto> pluginDtosByKey;
        SortedSet<PluginInfo> pluginInfoList = this.searchPluginInfoList();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            pluginDtosByKey = this.dbClient.pluginDao().selectAll(dbSession).stream().collect(Collectors.toMap(PluginDto::getKee, Function.identity()));
        }
        JsonWriter jsonWriter = response.newJsonWriter();
        jsonWriter.setSerializeEmptys(false);
        jsonWriter.beginObject();
        List additionalFields = request.paramAsStrings("f");
        this.writePluginInfoList(jsonWriter, pluginInfoList, additionalFields == null ? Collections.emptyList() : additionalFields, pluginDtosByKey);
        jsonWriter.endObject();
        jsonWriter.close();
    }

    private SortedSet<PluginInfo> searchPluginInfoList() {
        return ImmutableSortedSet.copyOf(PluginWSCommons.NAME_KEY_PLUGIN_METADATA_COMPARATOR, this.pluginRepository.getPluginInfos());
    }

    private void writePluginInfoList(JsonWriter jsonWriter, Collection<PluginInfo> pluginInfoList, List<String> additionalFields, Map<String, PluginDto> pluginDtos) {
        Map<String, Plugin> compatiblesPluginsFromUpdateCenter = additionalFields.isEmpty() ? Collections.emptyMap() : PluginWSCommons.compatiblePluginsByKey(this.updateCenterMatrixFactory);
        this.pluginWSCommons.writePluginInfoList(jsonWriter, pluginInfoList, compatiblesPluginsFromUpdateCenter, ARRAY_PLUGINS, pluginDtos);
    }
}

