/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.common.io.Resources;
import java.util.Comparator;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.process.cluster.health.NodeDetails;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.server.health.ClusterHealth;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthChecker;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonarqube.ws.WsSystem;

public class HealthActionSupport {
    private static final Comparator<NodeHealth> NODE_HEALTH_COMPARATOR = Comparator.comparingInt(s -> s.getDetails().getType().ordinal()).thenComparing(a -> a.getDetails().getName()).thenComparing(a -> a.getDetails().getHost()).thenComparing(a -> a.getDetails().getPort());
    private final HealthChecker healthChecker;

    public HealthActionSupport(HealthChecker healthChecker) {
        this.healthChecker = healthChecker;
    }

    void define(WebService.NewController controller, SystemWsAction handler) {
        controller.createAction("health").setDescription("Provide health status of SonarQube.<p>Require 'Administer System' permission or authentication with passcode</p><p>  <ul> <li>GREEN: SonarQube is fully operational</li> <li>YELLOW: SonarQube is usable, but it needs attention in order to be fully operational</li> <li>RED: SonarQube is not operational</li> </ul></p>").setSince("6.6").setResponseExample(Resources.getResource(this.getClass(), (String)"example-health.json")).setHandler((RequestHandler)handler);
    }

    WsSystem.HealthResponse checkNodeHealth() {
        Health check = this.healthChecker.checkNode();
        WsSystem.HealthResponse.Builder responseBuilder = WsSystem.HealthResponse.newBuilder().setHealth(WsSystem.Health.valueOf((String)check.getStatus().name()));
        WsSystem.Cause.Builder causeBuilder = WsSystem.Cause.newBuilder();
        check.getCauses().forEach(str -> responseBuilder.addCauses(causeBuilder.clear().setMessage(str).build()));
        return responseBuilder.build();
    }

    WsSystem.HealthResponse checkClusterHealth() {
        ClusterHealth check = this.healthChecker.checkCluster();
        return HealthActionSupport.toResponse(check);
    }

    private static WsSystem.HealthResponse toResponse(ClusterHealth check) {
        WsSystem.HealthResponse.Builder responseBuilder = WsSystem.HealthResponse.newBuilder();
        WsSystem.Node.Builder nodeBuilder = WsSystem.Node.newBuilder();
        WsSystem.Cause.Builder causeBuilder = WsSystem.Cause.newBuilder();
        Health health = check.getHealth();
        responseBuilder.setHealth(WsSystem.Health.valueOf((String)health.getStatus().name()));
        health.getCauses().forEach(str -> responseBuilder.addCauses(HealthActionSupport.toCause(str, causeBuilder)));
        WsSystem.Nodes.Builder nodesBuilder = WsSystem.Nodes.newBuilder();
        check.getNodes().stream().sorted(NODE_HEALTH_COMPARATOR).map(node -> HealthActionSupport.toNode(node, nodeBuilder, causeBuilder)).forEach(arg_0 -> ((WsSystem.Nodes.Builder)nodesBuilder).addNodes(arg_0));
        responseBuilder.setNodes(nodesBuilder.build());
        return responseBuilder.build();
    }

    private static WsSystem.Node toNode(NodeHealth nodeHealth, WsSystem.Node.Builder nodeBuilder, WsSystem.Cause.Builder causeBuilder) {
        nodeBuilder.clear();
        nodeBuilder.setHealth(WsSystem.Health.valueOf((String)nodeHealth.getStatus().name()));
        nodeHealth.getCauses().forEach(str -> nodeBuilder.addCauses(HealthActionSupport.toCause(str, causeBuilder)));
        NodeDetails details = nodeHealth.getDetails();
        nodeBuilder.setType(WsSystem.NodeType.valueOf((String)details.getType().name())).setName(details.getName()).setHost(details.getHost()).setPort(details.getPort()).setStartedAt(DateUtils.formatDateTime((long)details.getStartedAt()));
        return nodeBuilder.build();
    }

    private static WsSystem.Cause toCause(String str, WsSystem.Cause.Builder causeBuilder) {
        return causeBuilder.clear().setMessage(str).build();
    }
}

