/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.platform.Platform;

public class MasterServletFilter
implements Filter {
    public static volatile MasterServletFilter INSTANCE;
    private ServletFilter[] filters;
    private FilterConfig config;

    public MasterServletFilter() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Servlet filter " + this.getClass().getName() + " is already instantiated");
        }
        INSTANCE = this;
    }

    public void init(FilterConfig config) throws ServletException {
        this.init(config, Platform.getInstance().getContainer().getComponentsByType(ServletFilter.class));
    }

    void init(FilterConfig config, List<ServletFilter> filters) throws ServletException {
        this.config = config;
        this.initFilters(filters);
    }

    public void initFilters(List<ServletFilter> filterExtensions) throws ServletException {
        ArrayList filterList = Lists.newArrayList();
        for (ServletFilter extension : filterExtensions) {
            try {
                Loggers.get(MasterServletFilter.class).info(String.format("Initializing servlet filter %s [pattern=%s]", extension, extension.doGetPattern().label()));
                extension.init(this.config);
                filterList.add(extension);
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to initialize servlet filter: " + extension + ". Message: " + e.getMessage(), e);
            }
        }
        this.filters = filterList.toArray(new ServletFilter[filterList.size()]);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest hsr = (HttpServletRequest)request;
        if (this.filters.length == 0) {
            chain.doFilter((ServletRequest)hsr, response);
        } else {
            String path = hsr.getRequestURI().replaceFirst(hsr.getContextPath(), "");
            GodFilterChain godChain = new GodFilterChain(chain);
            for (ServletFilter filter : this.filters) {
                if (!filter.doGetPattern().matches(path)) continue;
                godChain.addFilter((Filter)filter);
            }
            godChain.doFilter((ServletRequest)hsr, response);
        }
    }

    public void destroy() {
        for (ServletFilter filter : this.filters) {
            filter.destroy();
        }
    }

    @VisibleForTesting
    ServletFilter[] getFilters() {
        return this.filters;
    }

    private static final class GodFilterChain
    implements FilterChain {
        private FilterChain chain;
        private List<Filter> filters = Lists.newLinkedList();
        private Iterator<Filter> iterator;

        public GodFilterChain(FilterChain chain) {
            this.chain = chain;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.iterator == null) {
                this.iterator = this.filters.iterator();
            }
            if (this.iterator.hasNext()) {
                this.iterator.next().doFilter(request, response, (FilterChain)this);
            } else {
                this.chain.doFilter(request, response);
            }
        }

        public void addFilter(Filter filter) {
            Preconditions.checkState((this.iterator == null ? 1 : 0) != 0);
            this.filters.add(filter);
        }
    }
}

