/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.Startable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

@ServerSide
@ComputeEngineSide
public class ProcessInfoProvider
implements Startable {
    private static ProcessInfoProvider instance;
    private final List<SystemInfoSection> sections;

    public ProcessInfoProvider(SystemInfoSection[] sections) {
        this.sections = Arrays.stream(sections).filter(section -> !(section instanceof Global)).collect(Collectors.toList());
    }

    public void start() {
        instance = this;
    }

    public void stop() {
        instance = null;
    }

    public static ProtobufSystemInfo.SystemInfo provide() {
        ProtobufSystemInfo.SystemInfo.Builder protobuf = ProtobufSystemInfo.SystemInfo.newBuilder();
        if (instance != null) {
            ProcessInfoProvider.instance.sections.forEach(section -> protobuf.addSections(section.toProtobuf()));
        }
        return protobuf.build();
    }
}

