/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.organization.OrganizationDao;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.permission.SetDefaultTemplateWsRequest;

public class SetDefaultTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final ResourceTypes resourceTypes;
    private final UserSession userSession;
    private final I18n i18n;

    public SetDefaultTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, ResourceTypes resourceTypes, UserSession userSession, I18n i18n) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.resourceTypes = resourceTypes;
        this.userSession = userSession;
        this.i18n = i18n;
    }

    private static SetDefaultTemplateWsRequest toSetDefaultTemplateWsRequest(Request request) {
        return new SetDefaultTemplateWsRequest().setQualifier(request.param("qualifier")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("set_default_template").setDescription("Set a permission template as default.<br />Requires the following permission: 'Administer System'.").setPost(true).setSince("5.2").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        WsParameterBuilder.createDefaultTemplateQualifierParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes)).setDefaultValue((Object)"TRK");
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(SetDefaultTemplateAction.toSetDefaultTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(SetDefaultTemplateWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String qualifier = request.getQualifier();
            PermissionTemplateDto template = this.findTemplate(dbSession, request);
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            PermissionRequestValidator.validateQualifier(qualifier, this.resourceTypes);
            this.setDefaultTemplateUuid(dbSession, template, qualifier);
            dbSession.commit();
        }
    }

    private PermissionTemplateDto findTemplate(DbSession dbSession, SetDefaultTemplateWsRequest request) {
        return this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
    }

    private void setDefaultTemplateUuid(DbSession dbSession, PermissionTemplateDto permissionTemplateDto, String qualifier) {
        String organizationUuid = permissionTemplateDto.getOrganizationUuid();
        OrganizationDao organizationDao = this.dbClient.organizationDao();
        DefaultTemplates defaultTemplates = (DefaultTemplates)WsUtils.checkFoundWithOptional(organizationDao.getDefaultTemplates(dbSession, organizationUuid), "No Default templates for organization with uuid '%s'", organizationUuid);
        if ("TRK".equals(qualifier)) {
            defaultTemplates.setProjectUuid(permissionTemplateDto.getUuid());
        } else if ("VW".equals(qualifier)) {
            defaultTemplates.setViewUuid(permissionTemplateDto.getUuid());
        }
        organizationDao.setDefaultTemplates(dbSession, organizationUuid, defaultTemplates);
    }
}

