/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.List;
import org.apache.ibatis.session.ResultContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.permission.template.CountByTemplateAndPermissionDto;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;
import org.sonar.server.permission.ws.template.SearchTemplatesData;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.permission.SearchTemplatesWsRequest;

public class SearchTemplatesDataLoader {
    private final DbClient dbClient;
    private final DefaultTemplatesResolver defaultTemplatesResolver;

    public SearchTemplatesDataLoader(DbClient dbClient, DefaultTemplatesResolver defaultTemplatesResolver) {
        this.dbClient = dbClient;
        this.defaultTemplatesResolver = defaultTemplatesResolver;
    }

    public SearchTemplatesData load(DbSession dbSession, SearchTemplatesWsRequest request) {
        SearchTemplatesData.Builder data = SearchTemplatesData.builder();
        List<PermissionTemplateDto> templates = this.searchTemplates(dbSession, request);
        List templateIds = Lists.transform(templates, PermissionTemplateDto::getId);
        DefaultTemplates defaultTemplates = (DefaultTemplates)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().getDefaultTemplates(dbSession, request.getOrganizationUuid()), "No Default templates for organization with uuid '%s'", request.getOrganizationUuid());
        DefaultTemplatesResolver.ResolvedDefaultTemplates resolvedDefaultTemplates = this.defaultTemplatesResolver.resolve(defaultTemplates);
        data.templates(templates).defaultTemplates(resolvedDefaultTemplates).userCountByTemplateIdAndPermission(this.userCountByTemplateIdAndPermission(dbSession, templateIds)).groupCountByTemplateIdAndPermission(this.groupCountByTemplateIdAndPermission(dbSession, templateIds)).withProjectCreatorByTemplateIdAndPermission(this.withProjectCreatorsByTemplateIdAndPermission(dbSession, templateIds));
        return data.build();
    }

    private List<PermissionTemplateDto> searchTemplates(DbSession dbSession, SearchTemplatesWsRequest request) {
        return this.dbClient.permissionTemplateDao().selectAll(dbSession, request.getOrganizationUuid(), request.getQuery());
    }

    private Table<Long, String, Integer> userCountByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds) {
        TreeBasedTable userCountByTemplateIdAndPermission = TreeBasedTable.create();
        this.dbClient.permissionTemplateDao().usersCountByTemplateIdAndPermission(dbSession, templateIds, arg_0 -> SearchTemplatesDataLoader.lambda$userCountByTemplateIdAndPermission$0((Table)userCountByTemplateIdAndPermission, arg_0));
        return userCountByTemplateIdAndPermission;
    }

    private Table<Long, String, Integer> groupCountByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds) {
        TreeBasedTable userCountByTemplateIdAndPermission = TreeBasedTable.create();
        this.dbClient.permissionTemplateDao().groupsCountByTemplateIdAndPermission(dbSession, templateIds, arg_0 -> SearchTemplatesDataLoader.lambda$groupCountByTemplateIdAndPermission$1((Table)userCountByTemplateIdAndPermission, arg_0));
        return userCountByTemplateIdAndPermission;
    }

    private Table<Long, String, Boolean> withProjectCreatorsByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds) {
        TreeBasedTable templatePermissionsByTemplateIdAndPermission = TreeBasedTable.create();
        List templatePermissions = this.dbClient.permissionTemplateCharacteristicDao().selectByTemplateIds(dbSession, templateIds);
        templatePermissions.stream().forEach(arg_0 -> SearchTemplatesDataLoader.lambda$withProjectCreatorsByTemplateIdAndPermission$2((Table)templatePermissionsByTemplateIdAndPermission, arg_0));
        return templatePermissionsByTemplateIdAndPermission;
    }

    private static /* synthetic */ void lambda$withProjectCreatorsByTemplateIdAndPermission$2(Table templatePermissionsByTemplateIdAndPermission, PermissionTemplateCharacteristicDto templatePermission) {
        Boolean cfr_ignored_0 = (Boolean)templatePermissionsByTemplateIdAndPermission.put((Object)templatePermission.getTemplateId(), (Object)templatePermission.getPermission(), (Object)templatePermission.getWithProjectCreator());
    }

    private static /* synthetic */ void lambda$groupCountByTemplateIdAndPermission$1(Table userCountByTemplateIdAndPermission, ResultContext context) {
        CountByTemplateAndPermissionDto row = (CountByTemplateAndPermissionDto)context.getResultObject();
        userCountByTemplateIdAndPermission.put((Object)row.getTemplateId(), (Object)row.getPermission(), (Object)row.getCount());
    }

    private static /* synthetic */ void lambda$userCountByTemplateIdAndPermission$0(Table userCountByTemplateIdAndPermission, ResultContext context) {
        CountByTemplateAndPermissionDto row = (CountByTemplateAndPermissionDto)context.getResultObject();
        userCountByTemplateIdAndPermission.put((Object)row.getTemplateId(), (Object)row.getPermission(), (Object)row.getCount());
    }
}

