/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Collections;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionTemplateService;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.ProjectWsRef;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.permission.ApplyTemplateWsRequest;

public class ApplyTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionTemplateService permissionTemplateService;
    private final PermissionWsSupport wsSupport;

    public ApplyTemplateAction(DbClient dbClient, UserSession userSession, PermissionTemplateService permissionTemplateService, PermissionWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.permissionTemplateService = permissionTemplateService;
        this.wsSupport = wsSupport;
    }

    private static ApplyTemplateWsRequest toApplyTemplateWsRequest(Request request) {
        return new ApplyTemplateWsRequest().setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey")).setTemplateId(request.param("templateId")).setTemplateName(request.param("templateName")).setOrganization(request.param("organization"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("apply_template").setDescription("Apply a permission template to one project.<br>The project id or project key must be provided.<br>The template id or name must be provided.<br>Requires the following permission: 'Administer System'.").setPost(true).setSince("5.2").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(ApplyTemplateAction.toApplyTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(ApplyTemplateWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            ComponentDto project = this.wsSupport.getRootComponentOrModule(dbSession, ProjectWsRef.newWsProjectRef(request.getProjectId(), request.getProjectKey()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            this.permissionTemplateService.applyAndCommit(dbSession, template, Collections.singletonList(project));
        }
    }
}

