/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupIdOrAnyone;
import org.sonar.server.ws.WsUtils;

public class AddGroupToTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport support;
    private final UserSession userSession;

    public AddGroupToTemplateAction(DbClient dbClient, PermissionWsSupport support, UserSession userSession) {
        this.dbClient = dbClient;
        this.support = support;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_group_to_template").setPost(true).setSince("5.2").setDescription("Add a group to a permission template.<br /> The group id or group name must be provided. <br />Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createGroupIdParameter(action);
        PermissionsWsParametersBuilder.createGroupNameParameter(action);
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String permission = request.mandatoryParam("permission");
            GroupIdOrAnyone groupId = this.support.findGroup(dbSession, request);
            WsUtils.checkRequest(!"admin".equals(permission) || !groupId.isAnyone(), String.format("It is not possible to add the '%s' permission to the group 'Anyone'.", permission), new Object[0]);
            PermissionTemplateDto template = this.support.findTemplate(dbSession, WsTemplateRef.fromRequest(request));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            if (!this.groupAlreadyAdded(dbSession, template.getId(), permission, groupId)) {
                this.dbClient.permissionTemplateDao().insertGroupPermission(dbSession, template.getId().longValue(), groupId.getId(), permission);
                dbSession.commit();
            }
        }
        response.noContent();
    }

    private boolean groupAlreadyAdded(DbSession dbSession, long templateId, String permission, GroupIdOrAnyone group) {
        return this.dbClient.permissionTemplateDao().hasGroupsWithPermission(dbSession, templateId, permission, group.getId());
    }
}

