/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultContext;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.utils.Paging;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.permission.CountPerProjectPermission;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.ProjectWsRef;
import org.sonar.server.permission.ws.SearchProjectPermissionsData;
import org.sonarqube.ws.client.permission.SearchProjectPermissionsWsRequest;

public class SearchProjectPermissionsDataLoader {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final String[] rootQualifiers;

    public SearchProjectPermissionsDataLoader(DbClient dbClient, PermissionWsSupport wsSupport, ResourceTypes resourceTypes) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.rootQualifiers = Collections2.transform((Collection)resourceTypes.getRoots(), ResourceType::getQualifier).toArray(new String[resourceTypes.getRoots().size()]);
    }

    SearchProjectPermissionsData load(DbSession dbSession, SearchProjectPermissionsWsRequest request) {
        SearchProjectPermissionsData.Builder data = SearchProjectPermissionsData.newBuilder();
        int countRootComponents = this.countRootComponents(dbSession, request);
        List<ComponentDto> rootComponents = this.searchRootComponents(dbSession, request, SearchProjectPermissionsDataLoader.paging(request, countRootComponents));
        List rootComponentIds = Lists.transform(rootComponents, ComponentDto::getId);
        data.rootComponents(rootComponents).paging(SearchProjectPermissionsDataLoader.paging(request, countRootComponents)).userCountByProjectIdAndPermission(this.userCountByRootComponentIdAndPermission(dbSession, rootComponentIds)).groupCountByProjectIdAndPermission(this.groupCountByRootComponentIdAndPermission(dbSession, rootComponentIds));
        return data.build();
    }

    private static Paging paging(SearchProjectPermissionsWsRequest request, int total) {
        return Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal(total);
    }

    private int countRootComponents(DbSession dbSession, SearchProjectPermissionsWsRequest request) {
        return this.dbClient.componentDao().countByQuery(dbSession, this.toDbQuery(request));
    }

    private List<ComponentDto> searchRootComponents(DbSession dbSession, SearchProjectPermissionsWsRequest request, Paging paging) {
        Optional<ProjectWsRef> project = ProjectWsRef.newOptionalWsProjectRef(request.getProjectId(), request.getProjectKey());
        if (project.isPresent()) {
            return Collections.singletonList(this.wsSupport.getRootComponentOrModule(dbSession, (ProjectWsRef)project.get()));
        }
        return this.dbClient.componentDao().selectByQuery(dbSession, this.toDbQuery(request), paging.offset(), paging.pageSize());
    }

    private ComponentQuery toDbQuery(SearchProjectPermissionsWsRequest wsRequest) {
        return ComponentQuery.builder().setQualifiers(this.qualifiers(wsRequest.getQualifier())).setNameOrKeyQuery(wsRequest.getQuery()).build();
    }

    private String[] qualifiers(@Nullable String requestQualifier) {
        String[] stringArray;
        if (requestQualifier == null) {
            stringArray = this.rootQualifiers;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = requestQualifier;
        }
        return stringArray;
    }

    private Table<Long, String, Integer> userCountByRootComponentIdAndPermission(DbSession dbSession, List<Long> rootComponentIds) {
        TreeBasedTable userCountByRootComponentIdAndPermission = TreeBasedTable.create();
        this.dbClient.userPermissionDao().countUsersByProjectPermission(dbSession, rootComponentIds).forEach(arg_0 -> SearchProjectPermissionsDataLoader.lambda$userCountByRootComponentIdAndPermission$0((Table)userCountByRootComponentIdAndPermission, arg_0));
        return userCountByRootComponentIdAndPermission;
    }

    private Table<Long, String, Integer> groupCountByRootComponentIdAndPermission(DbSession dbSession, List<Long> rootComponentIds) {
        TreeBasedTable userCountByRootComponentIdAndPermission = TreeBasedTable.create();
        this.dbClient.groupPermissionDao().groupsCountByComponentIdAndPermission(dbSession, rootComponentIds, arg_0 -> SearchProjectPermissionsDataLoader.lambda$groupCountByRootComponentIdAndPermission$1((Table)userCountByRootComponentIdAndPermission, arg_0));
        return userCountByRootComponentIdAndPermission;
    }

    private static /* synthetic */ void lambda$groupCountByRootComponentIdAndPermission$1(Table userCountByRootComponentIdAndPermission, ResultContext context) {
        CountPerProjectPermission row = (CountPerProjectPermission)context.getResultObject();
        userCountByRootComponentIdAndPermission.put((Object)row.getComponentId(), (Object)row.getPermission(), (Object)row.getCount());
    }

    private static /* synthetic */ void lambda$userCountByRootComponentIdAndPermission$0(Table userCountByRootComponentIdAndPermission, CountPerProjectPermission row) {
        Integer cfr_ignored_0 = (Integer)userCountByRootComponentIdAndPermission.put((Object)row.getComponentId(), (Object)row.getPermission(), (Object)row.getCount());
    }
}

