/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.ws;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.notification.NotificationCenter;
import org.sonar.server.notification.NotificationUpdater;
import org.sonar.server.notification.email.EmailNotificationChannel;
import org.sonar.server.notification.ws.NotificationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.notification.RemoveRequest;

public class RemoveAction
implements NotificationsWsAction {
    private final NotificationCenter notificationCenter;
    private final NotificationUpdater notificationUpdater;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final List<String> globalDispatchers;
    private final List<String> projectDispatchers;

    public RemoveAction(NotificationCenter notificationCenter, NotificationUpdater notificationUpdater, DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.notificationCenter = notificationCenter;
        this.notificationUpdater = notificationUpdater;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.globalDispatchers = notificationCenter.getDispatcherKeysForProperty("globalNotification", "true");
        this.projectDispatchers = notificationCenter.getDispatcherKeysForProperty("perProjectNotification", "true");
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove").setDescription("Remove a notification for the authenticated user.<br>Requires one of the following permissions:<ul>  <li>Authentication if no login is provided</li>  <li>System administration if a login is provided</li></ul>").setSince("6.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("project").setDescription("Project key").setExampleValue((Object)"my_project");
        List<NotificationChannel> channels = this.notificationCenter.getChannels();
        action.createParam("channel").setDescription("Channel through which the notification is sent. For example, notifications can be sent by email.").setPossibleValues(channels).setDefaultValue((Object)EmailNotificationChannel.class.getSimpleName());
        action.createParam("type").setDescription("Notification type. Possible values are for:<ul>  <li>Global notifications: %s</li>  <li>Per project notifications: %s</li></ul>", new Object[]{this.globalDispatchers.stream().sorted().collect(Collectors.joining(", ")), this.projectDispatchers.stream().sorted().collect(Collectors.joining(", "))}).setRequired(true).setExampleValue((Object)"SQ-MyNewIssues");
        action.createParam("login").setDescription("User login").setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        RemoveRequest removeRequest = this.toWsRequest(request);
        this.remove(removeRequest);
        response.noContent();
    }

    private void remove(RemoveRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkPermissions(request);
            UserDto user = this.getUser(dbSession, request);
            Optional<ComponentDto> project = this.searchProject(dbSession, request);
            this.notificationUpdater.remove(dbSession, request.getChannel(), request.getType(), user, project.orElse(null));
            dbSession.commit();
        }
    }

    private UserDto getUser(DbSession dbSession, RemoveRequest request) {
        String login = request.getLogin() == null ? this.userSession.getLogin() : request.getLogin();
        return WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' not found", login);
    }

    private Optional<ComponentDto> searchProject(DbSession dbSession, RemoveRequest request) {
        Optional<ComponentDto> project = request.getProject() == null ? Optional.empty() : Optional.of(this.componentFinder.getByKey(dbSession, request.getProject()));
        project.ifPresent(p -> WsUtils.checkRequest("TRK".equals(p.qualifier()) && "PRJ".equals(p.scope()), "Component '%s' must be a project", request.getProject()));
        return project;
    }

    private void checkPermissions(RemoveRequest request) {
        if (request.getLogin() == null) {
            this.userSession.checkLoggedIn();
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private RemoveRequest toWsRequest(Request request) {
        RemoveRequest.Builder requestBuilder = RemoveRequest.builder().setType(request.mandatoryParam("type")).setChannel(request.mandatoryParam("channel"));
        Protobuf.setNullable((Object)request.param("project"), arg_0 -> ((RemoveRequest.Builder)requestBuilder).setProject(arg_0));
        Protobuf.setNullable((Object)request.param("login"), arg_0 -> ((RemoveRequest.Builder)requestBuilder).setLogin(arg_0));
        RemoveRequest wsRequest = requestBuilder.build();
        if (wsRequest.getProject() == null) {
            WsUtils.checkRequest(this.globalDispatchers.contains(wsRequest.getType()), "Value of parameter '%s' (%s) must be one of: %s", "type", wsRequest.getType(), this.globalDispatchers);
        } else {
            WsUtils.checkRequest(this.projectDispatchers.contains(wsRequest.getType()), "Value of parameter '%s' (%s) must be one of: %s", "type", wsRequest.getType(), this.projectDispatchers);
        }
        return wsRequest;
    }
}

