/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.issue.EditCommentRequest;

public class EditCommentAction
implements IssuesWsAction {
    private final System2 system2;
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final OperationResponseWriter responseWriter;

    public EditCommentAction(System2 system2, UserSession userSession, DbClient dbClient, IssueFinder issueFinder, OperationResponseWriter responseWriter) {
        this.system2 = system2;
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.responseWriter = responseWriter;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("edit_comment").setDescription("Edit a comment.<br/>Requires authentication and the following permission: 'Browse' on the project of the specified issue.").setSince("3.6").setChangelog(new Change[]{new Change("6.3", "the response returns the issue with all its details"), new Change("6.3", String.format("the 'key' parameter has been renamed %s", "comment")), new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead.")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"edit_comment-example.json")).setPost(true);
        action.createParam("comment").setDescription("Comment key").setDeprecatedKey("key", "6.3").setSince("6.3").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("text").setDescription("Comment text").setRequired(true).setExampleValue((Object)"Won't fix because it doesn't apply to the context");
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            IssueDto issueDto = ((CommentData)Stream.of(request).map(EditCommentAction.toWsRequest()).map(this.loadCommentData(dbSession)).peek(this.updateComment(dbSession)).collect(MoreCollectors.toOneElement())).getIssueDto();
            this.responseWriter.write(issueDto.getKey(), new SearchResponseData(issueDto), request, response);
        }
    }

    private Function<EditCommentRequest, CommentData> loadCommentData(DbSession dbSession) {
        return request -> new CommentData(dbSession, (EditCommentRequest)request);
    }

    private Consumer<CommentData> updateComment(DbSession dbSession) {
        return commentData -> {
            commentData.getIssueChangeDto().setUpdatedAt(Long.valueOf(this.system2.now()));
            commentData.getIssueChangeDto().setChangeData(commentData.getRequest().getText());
            this.dbClient.issueChangeDao().update(dbSession, commentData.getIssueChangeDto());
            dbSession.commit();
        };
    }

    private static Function<Request, EditCommentRequest> toWsRequest() {
        return request -> {
            EditCommentRequest wsRequest = new EditCommentRequest(request.mandatoryParam("comment"), request.mandatoryParam("text"));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)wsRequest.getText()) ? 1 : 0) != 0, (Object)"Cannot set empty comment to an issue");
            return wsRequest;
        };
    }

    private class CommentData {
        private final IssueChangeDto issueChangeDto;
        private final IssueDto issueDto;
        private final EditCommentRequest request;

        CommentData(DbSession dbSession, EditCommentRequest request) {
            this.request = request;
            this.issueChangeDto = (IssueChangeDto)EditCommentAction.this.dbClient.issueChangeDao().selectCommentByKey(dbSession, request.getComment()).orElseThrow(() -> new NotFoundException(String.format("Comment with key '%s' does not exist", request.getComment())));
            this.issueDto = EditCommentAction.this.issueFinder.getByKey(dbSession, this.issueChangeDto.getIssueKey());
            Preconditions.checkArgument((boolean)Objects.equals(this.issueChangeDto.getUserLogin(), EditCommentAction.this.userSession.getLogin()), (Object)"You can only edit your own comments");
        }

        IssueChangeDto getIssueChangeDto() {
            return this.issueChangeDto;
        }

        IssueDto getIssueDto() {
            return this.issueDto;
        }

        EditCommentRequest getRequest() {
            return this.request;
        }
    }
}

