/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.issue.ws.IssuesWs;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class ChangelogAction
implements IssuesWsAction {
    private static final String EFFORT_CHANGELOG_KEY = "effort";
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final AvatarResolver avatarFactory;

    public ChangelogAction(DbClient dbClient, IssueFinder issueFinder, AvatarResolver avatarFactory) {
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.avatarFactory = avatarFactory;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("changelog").setDescription("Display changelog of an issue.<br/>Requires the 'Browse' permission on the project of the specified issue.").setSince("4.1").setChangelog(new Change[]{new Change("6.3", "changes on effort is expressed with the raw value in minutes (instead of the duration previously)")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(IssuesWs.class, (String)"changelog-example.json"));
        action.createParam("issue").setDescription("Issue key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Issues.ChangelogWsResponse wsResponse = (Issues.ChangelogWsResponse)Stream.of(request).map(this.searchChangelog(dbSession)).map(this.buildResponse()).collect(MoreCollectors.toOneElement());
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private Function<Request, ChangeLogResults> searchChangelog(DbSession dbSession) {
        return request -> new ChangeLogResults(dbSession, request.mandatoryParam("issue"));
    }

    private Function<ChangeLogResults, Issues.ChangelogWsResponse> buildResponse() {
        return result -> (Issues.ChangelogWsResponse)Stream.of(Issues.ChangelogWsResponse.newBuilder()).peek(this.addChanges((ChangeLogResults)result)).map(Issues.ChangelogWsResponse.Builder::build).collect(MoreCollectors.toOneElement());
    }

    private Consumer<Issues.ChangelogWsResponse.Builder> addChanges(ChangeLogResults results) {
        return response -> results.changes.stream().map(this.toWsChangelog(results)).forEach(arg_0 -> ((Issues.ChangelogWsResponse.Builder)response).addChangelog(arg_0));
    }

    private Function<FieldDiffs, Issues.ChangelogWsResponse.Changelog> toWsChangelog(ChangeLogResults results) {
        return change -> {
            UserDto user;
            String userLogin = change.userLogin();
            Issues.ChangelogWsResponse.Changelog.Builder changelogBuilder = Issues.ChangelogWsResponse.Changelog.newBuilder();
            changelogBuilder.setCreationDate(DateUtils.formatDateTime((Date)change.creationDate()));
            UserDto userDto = user = userLogin == null ? null : (UserDto)results.users.get(userLogin);
            if (user != null) {
                changelogBuilder.setUser(user.getLogin());
                changelogBuilder.setUserName(user.getName());
                Protobuf.setNullable((Object)Strings.emptyToNull((String)user.getEmail()), email -> changelogBuilder.setAvatar(this.avatarFactory.create(user)));
            }
            change.diffs().entrySet().stream().map(ChangelogAction.toWsDiff(results)).forEach(arg_0 -> ((Issues.ChangelogWsResponse.Changelog.Builder)changelogBuilder).addDiffs(arg_0));
            return changelogBuilder.build();
        };
    }

    private static Function<Map.Entry<String, FieldDiffs.Diff>, Issues.ChangelogWsResponse.Changelog.Diff> toWsDiff(ChangeLogResults results) {
        return diff -> {
            FieldDiffs.Diff value = (FieldDiffs.Diff)diff.getValue();
            Issues.ChangelogWsResponse.Changelog.Diff.Builder diffBuilder = Issues.ChangelogWsResponse.Changelog.Diff.newBuilder();
            String key = (String)diff.getKey();
            if (key.equals("file")) {
                diffBuilder.setKey(key);
                Protobuf.setNullable((Object)results.getFileLongName(Strings.emptyToNull((String)value.newValue().toString())), arg_0 -> ((Issues.ChangelogWsResponse.Changelog.Diff.Builder)diffBuilder).setNewValue(arg_0));
                Protobuf.setNullable((Object)results.getFileLongName(Strings.emptyToNull((String)value.oldValue().toString())), arg_0 -> ((Issues.ChangelogWsResponse.Changelog.Diff.Builder)diffBuilder).setOldValue(arg_0));
            } else {
                diffBuilder.setKey(key.equals("technicalDebt") ? EFFORT_CHANGELOG_KEY : key);
                Protobuf.setNullable((Object)Strings.emptyToNull((String)value.newValue().toString()), arg_0 -> ((Issues.ChangelogWsResponse.Changelog.Diff.Builder)diffBuilder).setNewValue(arg_0));
                Protobuf.setNullable((Object)Strings.emptyToNull((String)value.oldValue().toString()), arg_0 -> ((Issues.ChangelogWsResponse.Changelog.Diff.Builder)diffBuilder).setOldValue(arg_0));
            }
            return diffBuilder.build();
        };
    }

    private class ChangeLogResults {
        private final List<FieldDiffs> changes;
        private final Map<String, UserDto> users;
        private final Map<String, ComponentDto> files;

        ChangeLogResults(DbSession dbSession, String issueKey) {
            IssueDto dbIssue = ChangelogAction.this.issueFinder.getByKey(dbSession, issueKey);
            this.changes = ChangelogAction.this.dbClient.issueChangeDao().selectChangelogByIssue(dbSession, dbIssue.getKey());
            List logins = (List)this.changes.stream().filter(change -> change.userLogin() != null).map(FieldDiffs::userLogin).collect(MoreCollectors.toList());
            this.users = (Map)ChangelogAction.this.dbClient.userDao().selectByLogins(dbSession, (Collection)logins).stream().collect(MoreCollectors.uniqueIndex(UserDto::getLogin));
            this.files = (Map)ChangelogAction.this.dbClient.componentDao().selectByUuids(dbSession, this.getFileUuids(this.changes)).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid, Function.identity()));
        }

        private Set<String> getFileUuids(List<FieldDiffs> changes) {
            return (Set)changes.stream().filter(diffs -> diffs.diffs().containsKey("file")).flatMap(diffs -> Stream.of(diffs.get("file").newValue().toString(), diffs.get("file").oldValue().toString())).collect(MoreCollectors.toSet());
        }

        @CheckForNull
        String getFileLongName(@Nullable String fileUuid) {
            if (fileUuid == null) {
                return null;
            }
            ComponentDto file = this.files.get(fileUuid);
            return file == null ? null : file.longName();
        }
    }
}

