/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import java.util.Date;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.IssueUpdater;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.issue.AddCommentRequest;

public class AddCommentAction
implements IssuesWsAction {
    private final System2 system2;
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final IssueUpdater issueUpdater;
    private final IssueFieldsSetter issueFieldsSetter;
    private final OperationResponseWriter responseWriter;

    public AddCommentAction(System2 system2, UserSession userSession, DbClient dbClient, IssueFinder issueFinder, IssueUpdater issueUpdater, IssueFieldsSetter issueFieldsSetter, OperationResponseWriter responseWriter) {
        this.system2 = system2;
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.issueUpdater = issueUpdater;
        this.issueFieldsSetter = issueFieldsSetter;
        this.responseWriter = responseWriter;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_comment").setDescription("Add a comment.<br/>Requires authentication and the following permission: 'Browse' on the project of the specified issue.").setSince("3.6").setChangelog(new Change[]{new Change("6.3", "the response returns the issue with all its details"), new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead.")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"add_comment-example.json")).setPost(true);
        action.createParam("issue").setDescription("Issue key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("text").setDescription("Comment text").setRequired(true).setExampleValue((Object)"Won't fix because it doesn't apply to the context");
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn();
        AddCommentRequest wsRequest = AddCommentAction.toWsRequest(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            IssueDto issueDto = this.issueFinder.getByKey(dbSession, wsRequest.getIssue());
            IssueChangeContext context = IssueChangeContext.createUser((Date)new Date(this.system2.now()), (String)this.userSession.getLogin());
            DefaultIssue defaultIssue = issueDto.toDefaultIssue();
            this.issueFieldsSetter.addComment(defaultIssue, wsRequest.getText(), context);
            SearchResponseData preloadedSearchResponseData = this.issueUpdater.saveIssueAndPreloadSearchResponseData(dbSession, defaultIssue, context, wsRequest.getText());
            this.responseWriter.write(defaultIssue.key(), preloadedSearchResponseData, request, response);
        }
    }

    private static AddCommentRequest toWsRequest(Request request) {
        AddCommentRequest wsRequest = new AddCommentRequest(request.mandatoryParam("issue"), request.mandatoryParam("text"));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)wsRequest.getText()) ? 1 : 0) != 0, (Object)"Cannot add empty comment to an issue");
        return wsRequest;
    }
}

