/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import java.util.Collection;
import javax.annotation.Nullable;
import org.sonar.db.DbClient;
import org.sonar.server.issue.index.IssueIterator;
import org.sonar.server.issue.index.IssueIteratorForMultipleChunks;
import org.sonar.server.issue.index.IssueIteratorForSingleChunk;

public class IssueIteratorFactory {
    private final DbClient dbClient;

    public IssueIteratorFactory(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public IssueIterator createForAll() {
        return this.createForProject(null);
    }

    public IssueIterator createForProject(@Nullable String projectUuid) {
        return new IssueIteratorForSingleChunk(this.dbClient, projectUuid, null);
    }

    public IssueIterator createForIssueKeys(Collection<String> issueKeys) {
        return new IssueIteratorForMultipleChunks(this.dbClient, issueKeys);
    }
}

