/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite.ws;

import java.util.function.Consumer;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.favorite.FavoriteUpdater;
import org.sonar.server.favorite.ws.FavoritesWsAction;
import org.sonar.server.user.UserSession;

public class AddAction
implements FavoritesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final FavoriteUpdater favoriteUpdater;
    private final ComponentFinder componentFinder;

    public AddAction(UserSession userSession, DbClient dbClient, FavoriteUpdater favoriteUpdater, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.favoriteUpdater = favoriteUpdater;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add").setDescription("Add a component (project, directory, file etc.) as favorite for the authenticated user.<br>Requires authentication and the following permission: 'Browse' on the project of the specified component.").setSince("6.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setRequired(true).setExampleValue((Object)"my_project:/src/foo/Bar.php");
    }

    public void handle(Request request, Response response) throws Exception {
        this.addFavorite().accept(request);
        response.noContent();
    }

    private Consumer<Request> addFavorite() {
        return request -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                ComponentDto componentDto = this.componentFinder.getByKey(dbSession, request.mandatoryParam("component"));
                this.userSession.checkLoggedIn().checkComponentPermission("user", componentDto);
                this.favoriteUpdater.add(dbSession, componentDto, this.userSession.isLoggedIn() ? this.userSession.getUserId() : null);
                dbSession.commit();
            }
        };
    }
}

