/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyGetRequestBuilder
extends GetRequestBuilder {
    public ProxyGetRequestBuilder(Client client) {
        super((ElasticsearchClient)client, GetAction.INSTANCE);
    }

    public GetResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            GetResponse getResponse = (GetResponse)super.execute().actionGet();
            return getResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public GetResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public GetResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<GetResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder().append("ES get request");
        message.append(String.format(" for key '%s'", ((GetRequest)this.request).id()));
        message.append(String.format(" on index '%s'", ((GetRequest)this.request).index()));
        message.append(String.format(" on type '%s'", ((GetRequest)this.request).type()));
        return message.toString();
    }
}

