/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import java.util.Set;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyBulkRequestBuilder
extends BulkRequestBuilder {
    public ProxyBulkRequestBuilder(Client client) {
        super((ElasticsearchClient)client, BulkAction.INSTANCE);
    }

    public BulkResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            BulkResponse bulkResponse = (BulkResponse)super.execute().actionGet();
            return bulkResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public BulkResponse get(TimeValue timeout) {
        throw ProxyBulkRequestBuilder.unsupported();
    }

    public BulkResponse get(String timeout) {
        throw ProxyBulkRequestBuilder.unsupported();
    }

    public ListenableActionFuture<BulkResponse> execute() {
        throw ProxyBulkRequestBuilder.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        throw new UnsupportedOperationException("See " + ProxyBulkRequestBuilder.class.getName());
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("Bulk[");
        LinkedHashMultiset groupedRequests = LinkedHashMultiset.create();
        for (int i = 0; i < ((BulkRequest)this.request).requests().size(); ++i) {
            String docType;
            String index;
            String requestType;
            IndexRequest request;
            DocWriteRequest item = (DocWriteRequest)((BulkRequest)this.request).requests().get(i);
            if (item instanceof IndexRequest) {
                request = (IndexRequest)item;
                requestType = "index";
                index = request.index();
                docType = request.type();
            } else if (item instanceof UpdateRequest) {
                request = (UpdateRequest)item;
                requestType = "update";
                index = request.index();
                docType = request.type();
            } else if (item instanceof DeleteRequest) {
                request = (DeleteRequest)item;
                requestType = "delete";
                index = request.index();
                docType = request.type();
            } else {
                throw new IllegalStateException("Unsupported bulk request type: " + item.getClass());
            }
            groupedRequests.add((Object)new BulkRequestKey(requestType, index, docType));
        }
        Set entrySet = groupedRequests.entrySet();
        int size = entrySet.size();
        int current = 0;
        for (Multiset.Entry requestEntry : entrySet) {
            message.append(requestEntry.getCount()).append(" ").append(((BulkRequestKey)requestEntry.getElement()).toString());
            if (++current >= size) continue;
            message.append(", ");
        }
        message.append("]");
        return message.toString();
    }

    private static class BulkRequestKey {
        private String requestType;
        private String index;
        private String docType;

        private BulkRequestKey(String requestType, String index, String docType) {
            this.requestType = requestType;
            this.index = index;
            this.docType = docType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BulkRequestKey that = (BulkRequestKey)o;
            if (!this.docType.equals(that.docType)) {
                return false;
            }
            if (!this.index.equals(that.index)) {
                return false;
            }
            return this.requestType.equals(that.requestType);
        }

        public int hashCode() {
            int result = this.requestType.hashCode();
            result = 31 * result + this.index.hashCode();
            result = 31 * result + this.docType.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s request(s) on index %s and type %s", this.requestType, this.index, this.docType);
        }
    }
}

