/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.edition.EditionManagementState;
import org.sonar.server.edition.MutableEditionManagementState;
import org.sonar.server.edition.ws.EditionsWsAction;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.plugins.edition.EditionInstaller;
import org.sonar.server.user.UserSession;

public class UninstallAction
implements EditionsWsAction {
    private final UserSession userSession;
    private final MutableEditionManagementState mutableEditionManagementState;
    private final EditionInstaller editionInstaller;

    public UninstallAction(UserSession userSession, MutableEditionManagementState mutableEditionManagementState, EditionInstaller editionInstaller) {
        this.userSession = userSession;
        this.mutableEditionManagementState = mutableEditionManagementState;
        this.editionInstaller = editionInstaller;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("uninstall").setSince("6.7").setPost(true).setDescription("Uninstall the currently installed edition. Requires 'Administer System' permission.").setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        EditionManagementState.PendingStatus status = this.mutableEditionManagementState.getPendingInstallationStatus();
        if (status != EditionManagementState.PendingStatus.NONE && status != EditionManagementState.PendingStatus.UNINSTALL_IN_PROGRESS) {
            throw BadRequestException.create("Uninstall of the current edition is not allowed when install of an edition is in progress");
        }
        this.editionInstaller.uninstall();
        this.mutableEditionManagementState.uninstall();
        response.noContent();
    }
}

