/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition.ws;

import com.google.protobuf.Message;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.edition.ws.EditionsWsAction;
import org.sonar.server.measure.index.ProjectMeasuresIndex;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsEditions;

public class FormDataAction
implements EditionsWsAction {
    private final UserSession userSession;
    private final Server server;
    private final ProjectMeasuresIndex measuresIndex;

    public FormDataAction(UserSession userSession, Server server, ProjectMeasuresIndex measuresIndex) {
        this.userSession = userSession;
        this.server = server;
        this.measuresIndex = measuresIndex;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("form_data").setSince("6.7").setPost(false).setDescription("Provide data to prefill license request forms: the server ID and the total number of lines of code.").setResponseExample(this.getClass().getResource("example-edition-form_data.json")).setInternal(true).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        String serverId = this.server.getId();
        long nloc = this.measuresIndex.searchTelemetryStatistics().getNcloc();
        WsEditions.FormDataResponse responsePayload = WsEditions.FormDataResponse.newBuilder().setNcloc(nloc).setServerId(serverId).build();
        WsUtils.writeProtobuf((Message)responsePayload, request, response);
    }
}

