/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.edition.EditionManagementState;
import org.sonar.server.edition.License;
import org.sonar.server.edition.MutableEditionManagementState;
import org.sonar.server.edition.ws.EditionsWsAction;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.license.LicenseCommit;
import org.sonar.server.platform.WebServer;
import org.sonar.server.plugins.edition.EditionInstaller;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsEditions;

public class ApplyLicenseAction
implements EditionsWsAction {
    private static final String PARAM_LICENSE = "license";
    private final UserSession userSession;
    private final MutableEditionManagementState editionManagementState;
    private final EditionInstaller editionInstaller;
    private final WebServer webServer;
    @CheckForNull
    private final LicenseCommit licenseCommit;

    public ApplyLicenseAction(UserSession userSession, MutableEditionManagementState editionManagementState, EditionInstaller editionInstaller, WebServer webServer) {
        this(userSession, editionManagementState, editionInstaller, webServer, null);
    }

    public ApplyLicenseAction(UserSession userSession, MutableEditionManagementState editionManagementState, EditionInstaller editionInstaller, WebServer webServer, @Nullable LicenseCommit licenseCommit) {
        this.userSession = userSession;
        this.editionManagementState = editionManagementState;
        this.editionInstaller = editionInstaller;
        this.webServer = webServer;
        this.licenseCommit = licenseCommit;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("apply_license").setSince("6.7").setPost(true).setDescription("Apply changes to SonarQube to match the specified license. Clear error message of previous automatic install of an edition, if there is any. Require 'Administer System' permission.").setResponseExample(this.getClass().getResource("example-edition-apply_license.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_LICENSE).setRequired(true).setSince("6.7").setDescription("the license");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        if (this.editionManagementState.getPendingInstallationStatus() != EditionManagementState.PendingStatus.NONE) {
            throw BadRequestException.create("Can't apply a license when applying one is already in progress");
        }
        String licenseParam = request.mandatoryParam(PARAM_LICENSE);
        License newLicense = License.parse(licenseParam).orElseThrow(() -> BadRequestException.create("The license provided is invalid"));
        if (!this.webServer.isStandalone()) {
            Preconditions.checkState((this.licenseCommit != null ? 1 : 0) != 0, (Object)"LicenseCommit instance not found. License-manager plugin should be installed.");
            this.setLicenseWithoutInstall(newLicense);
        } else if (this.editionInstaller.requiresInstallationChange(newLicense.getPluginKeys())) {
            this.editionInstaller.install(newLicense);
        } else {
            Preconditions.checkState((this.licenseCommit != null ? 1 : 0) != 0, (Object)"Can't decide edition does not require install if LicenseCommit instance is null. License-manager plugin should be installed.");
            this.setLicenseWithoutInstall(newLicense);
        }
        WsUtils.writeProtobuf((Message)this.buildResponse(), request, response);
    }

    private void setLicenseWithoutInstall(License newLicense) {
        try {
            this.licenseCommit.update(newLicense.getContent());
            this.editionManagementState.newEditionWithoutInstall(newLicense.getEditionKey());
        }
        catch (IllegalArgumentException e) {
            Loggers.get(ApplyLicenseAction.class).error("Failed to commit license", (Throwable)e);
            throw BadRequestException.create(e.getMessage());
        }
    }

    private WsEditions.StatusResponse buildResponse() {
        WsEditions.StatusResponse.Builder builder = WsEditions.StatusResponse.newBuilder().setNextEditionKey(this.editionManagementState.getPendingEditionKey().orElse("")).setCurrentEditionKey(this.editionManagementState.getCurrentEditionKey().orElse("")).setInstallationStatus(WsEditions.InstallationStatus.valueOf((String)this.editionManagementState.getPendingInstallationStatus().name()));
        this.editionManagementState.getInstallErrorMessage().ifPresent(arg_0 -> ((WsEditions.StatusResponse.Builder)builder).setInstallError(arg_0));
        return builder.build();
    }
}

