/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@Immutable
public class License {
    private static final Logger LOG = Loggers.get(License.class);
    private static final String EDITION_KEY = "Edition";
    private static final String PLUGINS_KEY = "Plugins";
    private final String editionKey;
    private final Set<String> pluginKeys;
    private final String content;

    public License(String editionKey, Collection<String> pluginKeys, String content) {
        this.editionKey = License.enforceNotNullNorEmpty(editionKey, "editionKey");
        this.pluginKeys = ImmutableSet.copyOf(pluginKeys);
        this.content = License.enforceNotNullNorEmpty(content, "content");
    }

    private static String enforceNotNullNorEmpty(String str, String propertyName) {
        Preconditions.checkNotNull((Object)str, (String)"%s can't be null", (Object[])new Object[]{propertyName});
        Preconditions.checkArgument((!str.isEmpty() ? 1 : 0) != 0, (String)"%s can't be empty", (Object[])new Object[]{propertyName});
        return str;
    }

    public String getEditionKey() {
        return this.editionKey;
    }

    public Set<String> getPluginKeys() {
        return this.pluginKeys;
    }

    public String getContent() {
        return this.content;
    }

    public static Optional<License> parse(String base64) {
        try {
            String data = new String(Base64.decodeBase64((byte[])base64.trim().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            Properties props = new Properties();
            props.load(new StringReader(data));
            String[] plugins = StringUtils.split((String)props.getProperty(PLUGINS_KEY), (char)',');
            String editionKey = props.getProperty(EDITION_KEY);
            if (StringUtils.isNotBlank((String)editionKey) && plugins.length > 0) {
                return Optional.of(new License(editionKey, Arrays.asList(plugins), base64));
            }
            LOG.debug("Failed to parse license: no edition key and/or no plugin found");
        }
        catch (Exception e) {
            LOG.debug("Failed to parse license", (Object)e);
        }
        return Optional.empty();
    }
}

