/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.MeasureQuery;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.duplication.ws.DuplicationsParser;
import org.sonar.server.duplication.ws.DuplicationsWsAction;
import org.sonar.server.duplication.ws.ShowResponseBuilder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class ShowAction
implements DuplicationsWsAction {
    private final DbClient dbClient;
    private final DuplicationsParser parser;
    private final ShowResponseBuilder responseBuilder;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public ShowAction(DbClient dbClient, DuplicationsParser parser, ShowResponseBuilder responseBuilder, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.parser = parser;
        this.responseBuilder = responseBuilder;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setDescription("Get duplications. Require Browse permission on file's project").setSince("4.4").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("show-example.json"));
        action.setChangelog(new Change[]{new Change("6.5", "The fields 'uuid', 'projectUuid', 'subProjectUuid' are deprecated in the response.")});
        action.createParam("key").setDescription("File key").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam("uuid").setDeprecatedSince("6.5").setDescription("File ID. If provided, 'key' must not be provided.").setExampleValue((Object)"584a89f2-8037-4f7b-b82c-8b45d2d63fb2");
        action.createParam("branch").setDescription("Branch key").setInternal(true).setExampleValue((Object)"feature/my_branch");
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            this.userSession.checkComponentPermission("codeviewer", component);
            String duplications = this.findDataFromComponent(dbSession, component);
            String branch = component.getBranch();
            List<DuplicationsParser.Block> blocks = this.parser.parse(dbSession, component, branch, duplications);
            WsUtils.writeProtobuf((Message)this.responseBuilder.build(dbSession, blocks, branch), request, response);
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentUuid = request.param("uuid");
        String branch = request.param("branch");
        Preconditions.checkArgument((componentUuid == null || branch == null ? 1 : 0) != 0, (String)"'%s' and '%s' parameters cannot be used at the same time", (Object[])new Object[]{"uuid", "branch"});
        if (branch == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentUuid, request.param("key"), ComponentFinder.ParamNames.UUID_AND_KEY);
        }
        return this.componentFinder.getByKeyAndOptionalBranch(dbSession, request.mandatoryParam("key"), branch);
    }

    @CheckForNull
    private String findDataFromComponent(DbSession dbSession, ComponentDto component) {
        MeasureQuery query = MeasureQuery.builder().setComponentUuid(component.uuid()).setMetricKey("duplications_data").build();
        return this.dbClient.measureDao().selectSingle(dbSession, query).map(MeasureDto::getData).orElse(null);
    }
}

