/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.taskprocessor;

import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.ce.queue.CeTask;
import org.sonar.ce.queue.CeTaskResult;
import org.sonar.ce.taskprocessor.CeTaskProcessor;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.plugin.ce.ReportAnalysisComponentProvider;
import org.sonar.server.computation.task.container.TaskContainer;
import org.sonar.server.computation.task.projectanalysis.container.ContainerFactory;
import org.sonar.server.computation.task.step.ComputationStepExecutor;
import org.sonar.server.computation.taskprocessor.TaskResultHolder;

public class ReportTaskProcessor
implements CeTaskProcessor {
    private static final Set<String> HANDLED_TYPES = Collections.singleton("REPORT");
    private final ContainerFactory containerFactory;
    private final ComponentContainer serverContainer;
    @CheckForNull
    private final ReportAnalysisComponentProvider[] componentProviders;

    public ReportTaskProcessor(ContainerFactory containerFactory, ComponentContainer serverContainer, ReportAnalysisComponentProvider[] componentProviders) {
        this.containerFactory = containerFactory;
        this.serverContainer = serverContainer;
        this.componentProviders = componentProviders;
    }

    public ReportTaskProcessor(ContainerFactory containerFactory, ComponentContainer serverContainer) {
        this.containerFactory = containerFactory;
        this.serverContainer = serverContainer;
        this.componentProviders = null;
    }

    @Override
    public Set<String> getHandledCeTaskTypes() {
        return HANDLED_TYPES;
    }

    @Override
    public CeTaskResult process(CeTask task) {
        try (TaskContainer ceContainer = this.containerFactory.create(this.serverContainer, task, this.componentProviders);){
            ceContainer.bootup();
            ((ComputationStepExecutor)ceContainer.getComponentByType(ComputationStepExecutor.class)).execute();
            CeTaskResult ceTaskResult = ((TaskResultHolder)ceContainer.getComponentByType(TaskResultHolder.class)).getResult();
            return ceTaskResult;
        }
    }
}

