/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.formula.SumFormula;
import org.sonar.server.computation.task.projectanalysis.formula.counter.IntSumCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class UnitTestMeasuresStep
implements ComputationStep {
    private static final String[] METRICS = new String[]{"tests", "test_errors", "test_failures", "test_success_density"};
    private static final ImmutableList<Formula> FORMULAS = ImmutableList.of((Object)SumFormula.createLongSumFormula("test_execution_time"), (Object)SumFormula.createIntSumFormula("skipped_tests"), (Object)new UnitTestsFormula());
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public UnitTestMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)FORMULAS)).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute test measures";
    }

    private static class UnitTestsCounter
    implements Counter<UnitTestsCounter> {
        private final IntSumCounter testsCounter = new IntSumCounter("tests");
        private final IntSumCounter testsErrorsCounter = new IntSumCounter("test_errors");
        private final IntSumCounter testsFailuresCounter = new IntSumCounter("test_failures");

        private UnitTestsCounter() {
        }

        @Override
        public void aggregate(UnitTestsCounter counter) {
            this.testsCounter.aggregate(counter.testsCounter);
            this.testsErrorsCounter.aggregate(counter.testsErrorsCounter);
            this.testsFailuresCounter.aggregate(counter.testsFailuresCounter);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            this.testsCounter.initialize(context);
            this.testsErrorsCounter.initialize(context);
            this.testsFailuresCounter.initialize(context);
        }
    }

    private static class UnitTestsFormula
    implements Formula<UnitTestsCounter> {
        private UnitTestsFormula() {
        }

        @Override
        public UnitTestsCounter createNewCounter() {
            return new UnitTestsCounter();
        }

        @Override
        public Optional<Measure> createMeasure(UnitTestsCounter counter, CreateMeasureContext context) {
            String metricKey;
            switch (metricKey = context.getMetric().getKey()) {
                case "tests": {
                    return UnitTestsFormula.createMeasure(context.getComponent().getType(), counter.testsCounter.getValue());
                }
                case "test_errors": {
                    return UnitTestsFormula.createMeasure(context.getComponent().getType(), counter.testsErrorsCounter.getValue());
                }
                case "test_failures": {
                    return UnitTestsFormula.createMeasure(context.getComponent().getType(), counter.testsFailuresCounter.getValue());
                }
                case "test_success_density": {
                    return UnitTestsFormula.createDensityMeasure(counter, context.getMetric().getDecimalScale());
                }
            }
            throw new IllegalStateException(String.format("Metric '%s' is not supported", metricKey));
        }

        private static Optional<Measure> createMeasure(Component.Type componentType, Optional<Integer> metricValue) {
            if (metricValue.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(componentType)) {
                return Optional.of((Object)Measure.newMeasureBuilder().create((Integer)metricValue.get()));
            }
            return Optional.absent();
        }

        private static Optional<Measure> createDensityMeasure(UnitTestsCounter counter, int decimalScale) {
            if (UnitTestsFormula.isPositive(counter.testsCounter.getValue(), true) && UnitTestsFormula.isPositive(counter.testsErrorsCounter.getValue(), false) && UnitTestsFormula.isPositive(counter.testsFailuresCounter.getValue(), false)) {
                int tests = (Integer)counter.testsCounter.getValue().get();
                int errors = (Integer)counter.testsErrorsCounter.getValue().get();
                int failures = (Integer)counter.testsFailuresCounter.getValue().get();
                double density = (double)(errors + failures) * 100.0 / (double)tests;
                return Optional.of((Object)Measure.newMeasureBuilder().create(100.0 - density, decimalScale));
            }
            return Optional.absent();
        }

        private static boolean isPositive(Optional<Integer> value, boolean isStrictComparison) {
            return value.isPresent() && (isStrictComparison ? (Integer)value.get() > 0 : (Integer)value.get() >= 0);
        }

        @Override
        public String[] getOutputMetricKeys() {
            return METRICS;
        }
    }
}

