/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.FileSourceDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistTestsStep
implements ComputationStep {
    private static final Logger LOG = Loggers.get(PersistTestsStep.class);
    private final DbClient dbClient;
    private final System2 system;
    private final BatchReportReader reportReader;
    private final TreeRootHolder treeRootHolder;

    public PersistTestsStep(DbClient dbClient, System2 system, BatchReportReader reportReader, TreeRootHolder treeRootHolder) {
        this.dbClient = dbClient;
        this.system = system;
        this.reportReader = reportReader;
        this.treeRootHolder = treeRootHolder;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            TestDepthTraversalTypeAwareVisitor visitor = new TestDepthTraversalTypeAwareVisitor(dbSession);
            new DepthTraversalTypeAwareCrawler(visitor).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
            if (visitor.hasUnprocessedCoverageDetails) {
                LOG.warn("Some coverage tests are not taken into account during analysis of project '{}'", (Object)visitor.getProjectKey());
            }
        }
    }

    @Override
    public String getDescription() {
        return "Persist tests";
    }

    private class TestDepthTraversalTypeAwareVisitor
    extends TypeAwareVisitorAdapter {
        final DbSession session;
        final Map<String, FileSourceDto> existingFileSourcesByUuid;
        final String projectUuid;
        final String projectKey;
        boolean hasUnprocessedCoverageDetails;

        public TestDepthTraversalTypeAwareVisitor(DbSession session) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.hasUnprocessedCoverageDetails = false;
            this.session = session;
            this.existingFileSourcesByUuid = new HashMap<String, FileSourceDto>();
            this.projectUuid = PersistTestsStep.this.treeRootHolder.getRoot().getUuid();
            this.projectKey = PersistTestsStep.this.treeRootHolder.getRoot().getKey();
            session.select("org.sonar.db.source.FileSourceMapper.selectHashesForProject", (Object)ImmutableMap.of((Object)"projectUuid", (Object)PersistTestsStep.this.treeRootHolder.getRoot().getUuid(), (Object)"dataType", (Object)"TEST"), context -> {
                FileSourceDto dto = (FileSourceDto)context.getResultObject();
                this.existingFileSourcesByUuid.put(dto.getFileUuid(), dto);
            });
        }

        @Override
        public void visitFile(Component file) {
            if (file.getFileAttributes().isUnitTest()) {
                this.persistTestResults(file);
            }
        }

        private void persistTestResults(Component component) {
            Multimap<String, DbFileSources.Test.Builder> testsByName = this.buildDbTests(component.getReportAttributes().getRef());
            Table<String, String, DbFileSources.Test.CoveredFile.Builder> coveredFilesByName = this.loadCoverageDetails(component.getReportAttributes().getRef());
            List<DbFileSources.Test> tests = this.addCoveredFilesToTests(testsByName, coveredFilesByName);
            if (this.checkIfThereAreUnprocessedCoverageDetails(testsByName, coveredFilesByName, component.getKey())) {
                this.hasUnprocessedCoverageDetails = true;
            }
            if (tests.isEmpty()) {
                return;
            }
            String componentUuid = this.getUuid(component.getReportAttributes().getRef());
            FileSourceDto existingDto = this.existingFileSourcesByUuid.get(componentUuid);
            long now = PersistTestsStep.this.system.now();
            if (existingDto != null) {
                existingDto.setTestData(tests).setUpdatedAt(now);
                PersistTestsStep.this.dbClient.fileSourceDao().update(this.session, existingDto);
            } else {
                FileSourceDto newDto = new FileSourceDto().setTestData(tests).setFileUuid(componentUuid).setProjectUuid(this.projectUuid).setDataType("TEST").setCreatedAt(now).setUpdatedAt(now);
                PersistTestsStep.this.dbClient.fileSourceDao().insert(this.session, newDto);
            }
        }

        private boolean checkIfThereAreUnprocessedCoverageDetails(Multimap<String, DbFileSources.Test.Builder> testsByName, Table<String, String, DbFileSources.Test.CoveredFile.Builder> coveredFilesByName, String componentKey) {
            boolean hasUnprocessedCoverage;
            HashSet unprocessedCoverageDetailNames = new HashSet(coveredFilesByName.rowKeySet());
            unprocessedCoverageDetailNames.removeAll(testsByName.keySet());
            boolean bl = hasUnprocessedCoverage = !unprocessedCoverageDetailNames.isEmpty();
            if (hasUnprocessedCoverage) {
                LOG.trace("The following test coverages for file '{}' have not been taken into account: {}", (Object)componentKey, (Object)Joiner.on((String)", ").join(unprocessedCoverageDetailNames));
            }
            return hasUnprocessedCoverage;
        }

        private List<DbFileSources.Test> addCoveredFilesToTests(Multimap<String, DbFileSources.Test.Builder> testsByName, Table<String, String, DbFileSources.Test.CoveredFile.Builder> coveredFilesByName) {
            ArrayList<DbFileSources.Test> tests = new ArrayList<DbFileSources.Test>();
            for (DbFileSources.Test.Builder test : testsByName.values()) {
                Collection coveredFiles = coveredFilesByName.row((Object)test.getName()).values();
                if (!coveredFiles.isEmpty()) {
                    for (DbFileSources.Test.CoveredFile.Builder coveredFile : coveredFiles) {
                        test.addCoveredFile(coveredFile);
                    }
                }
                tests.add(test.build());
            }
            return tests;
        }

        private Multimap<String, DbFileSources.Test.Builder> buildDbTests(int componentRed) {
            ArrayListMultimap tests = ArrayListMultimap.create();
            try (CloseableIterator<ScannerReport.Test> testIterator = PersistTestsStep.this.reportReader.readTests(componentRed);){
                while (testIterator.hasNext()) {
                    ScannerReport.Test batchTest = (ScannerReport.Test)testIterator.next();
                    DbFileSources.Test.Builder dbTest = DbFileSources.Test.newBuilder();
                    dbTest.setUuid(Uuids.create());
                    dbTest.setName(batchTest.getName());
                    if (!batchTest.getStacktrace().isEmpty()) {
                        dbTest.setStacktrace(batchTest.getStacktrace());
                    }
                    if (batchTest.getStatus() != ScannerReport.Test.TestStatus.UNSET) {
                        dbTest.setStatus(DbFileSources.Test.TestStatus.valueOf((String)batchTest.getStatus().name()));
                    }
                    if (!batchTest.getMsg().isEmpty()) {
                        dbTest.setMsg(batchTest.getMsg());
                    }
                    dbTest.setExecutionTimeMs(batchTest.getDurationInMs());
                    tests.put((Object)dbTest.getName(), (Object)dbTest);
                }
            }
            return tests;
        }

        private Table<String, String, DbFileSources.Test.CoveredFile.Builder> loadCoverageDetails(int testFileRef) {
            HashBasedTable nameToCoveredFiles = HashBasedTable.create();
            try (CloseableIterator<ScannerReport.CoverageDetail> coverageIterator = PersistTestsStep.this.reportReader.readCoverageDetails(testFileRef);){
                while (coverageIterator.hasNext()) {
                    ScannerReport.CoverageDetail batchCoverageDetail = (ScannerReport.CoverageDetail)coverageIterator.next();
                    String testName = batchCoverageDetail.getTestName();
                    for (ScannerReport.CoverageDetail.CoveredFile batchCoveredFile : batchCoverageDetail.getCoveredFileList()) {
                        this.loadCoverageFile(batchCoveredFile, testName, (Table<String, String, DbFileSources.Test.CoveredFile.Builder>)nameToCoveredFiles);
                    }
                }
            }
            return nameToCoveredFiles;
        }

        private void loadCoverageFile(ScannerReport.CoverageDetail.CoveredFile batchCoveredFile, String testName, Table<String, String, DbFileSources.Test.CoveredFile.Builder> nameToCoveredFiles) {
            String mainFileUuid = this.getUuid(batchCoveredFile.getFileRef());
            DbFileSources.Test.CoveredFile.Builder existingDbCoveredFile = (DbFileSources.Test.CoveredFile.Builder)nameToCoveredFiles.get((Object)testName, (Object)mainFileUuid);
            List batchCoveredLines = batchCoveredFile.getCoveredLineList();
            if (existingDbCoveredFile == null) {
                DbFileSources.Test.CoveredFile.Builder dbCoveredFile = DbFileSources.Test.CoveredFile.newBuilder().setFileUuid(this.getUuid(batchCoveredFile.getFileRef())).addAllCoveredLine((Iterable)batchCoveredLines);
                nameToCoveredFiles.put((Object)testName, (Object)mainFileUuid, (Object)dbCoveredFile);
            } else {
                ArrayList remainingBatchCoveredLines = new ArrayList(batchCoveredLines);
                remainingBatchCoveredLines.removeAll(existingDbCoveredFile.getCoveredLineList());
                existingDbCoveredFile.addAllCoveredLine((Iterable)batchCoveredLines);
            }
        }

        private String getUuid(int fileRef) {
            return PersistTestsStep.this.treeRootHolder.getComponentByRef(fileRef).getUuid();
        }

        public String getProjectKey() {
            return this.projectKey;
        }
    }
}

