/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.ArrayList;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.AnalysisPropertyDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistAnalysisPropertiesStep
implements ComputationStep {
    private static final String SONAR_ANALYSIS = "sonar.analysis.";
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final BatchReportReader reportReader;
    private final UuidFactory uuidFactory;

    public PersistAnalysisPropertiesStep(DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder, BatchReportReader reportReader, UuidFactory uuidFactory) {
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.reportReader = reportReader;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute() {
        ArrayList analysisPropertyDtos = new ArrayList();
        this.reportReader.readContextProperties().forEachRemaining(contextProperty -> {
            if (contextProperty.getKey().startsWith(SONAR_ANALYSIS)) {
                analysisPropertyDtos.add(new AnalysisPropertyDto().setUuid(this.uuidFactory.create()).setKey(contextProperty.getKey()).setValue(contextProperty.getValue()).setSnapshotUuid(this.analysisMetadataHolder.getUuid()));
            }
        });
        if (analysisPropertyDtos.isEmpty()) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.analysisPropertiesDao().insert(dbSession, analysisPropertyDtos);
            dbSession.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Persist analysis properties";
    }
}

