/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class EnableAnalysisStep
implements ComputationStep {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public EnableAnalysisStep(DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Component project = this.treeRootHolder.getRoot();
            this.dbClient.snapshotDao().switchIsLastFlagAndSetProcessedStatus(dbSession, project.getUuid(), this.analysisMetadataHolder.getUuid());
            this.dbClient.componentDao().applyBChangesForRootComponentUuid(dbSession, project.getUuid());
            dbSession.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Enable analysis";
    }
}

