/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.source.LineReader;

public class CoverageLineReader
implements LineReader {
    private final Iterator<ScannerReport.LineCoverage> coverageIterator;
    private ScannerReport.LineCoverage coverage;

    public CoverageLineReader(Iterator<ScannerReport.LineCoverage> coverageIterator) {
        this.coverageIterator = coverageIterator;
    }

    @Override
    public void read(DbFileSources.Line.Builder lineBuilder) {
        ScannerReport.LineCoverage reportCoverage = this.getNextLineCoverageIfMatchLine(lineBuilder.getLine());
        if (reportCoverage != null) {
            CoverageLineReader.processCoverage(lineBuilder, reportCoverage);
            this.coverage = null;
        }
    }

    private static void processCoverage(DbFileSources.Line.Builder lineBuilder, ScannerReport.LineCoverage reportCoverage) {
        if (reportCoverage.getHasHitsCase() == ScannerReport.LineCoverage.HasHitsCase.HITS) {
            lineBuilder.setLineHits(reportCoverage.getHits() ? 1 : 0);
        }
        if (reportCoverage.getHasCoveredConditionsCase() == ScannerReport.LineCoverage.HasCoveredConditionsCase.COVERED_CONDITIONS) {
            lineBuilder.setConditions(reportCoverage.getConditions());
            lineBuilder.setCoveredConditions(reportCoverage.getCoveredConditions());
        }
    }

    @CheckForNull
    private ScannerReport.LineCoverage getNextLineCoverageIfMatchLine(int line) {
        if (this.coverage == null && this.coverageIterator.hasNext()) {
            this.coverage = this.coverageIterator.next();
        }
        if (this.coverage != null && this.coverage.getLine() == line) {
            return this.coverage;
        }
        return null;
    }
}

