/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoImpl;

@Immutable
class ReportScmInfo
implements ScmInfo {
    private final ScmInfo delegate;

    ReportScmInfo(ScannerReport.Changesets changesets) {
        Objects.requireNonNull(changesets);
        this.delegate = ReportScmInfo.convertToScmInfo(changesets);
    }

    private static ScmInfo convertToScmInfo(ScannerReport.Changesets changesets) {
        return new ScmInfoImpl((Iterable<Changeset>)FluentIterable.from((Iterable)new IntRangeIterable(changesets.getChangesetIndexByLineCount())).transform((Function)new LineIndexToChangeset(changesets)));
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.delegate.getLatestChangeset();
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        return this.delegate.getChangesetForLine(lineNumber);
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return this.delegate.hasChangesetForLine(lineNumber);
    }

    @Override
    public Iterable<Changeset> getAllChangesets() {
        return this.delegate.getAllChangesets();
    }

    private static class IntRangeIterator
    implements Iterator<Integer> {
        private final int max;
        private int current = 0;

        public IntRangeIterator(int max) {
            this.max = max;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.max;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.current;
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove cannot be called");
        }
    }

    private static final class IntRangeIterable
    implements Iterable<Integer> {
        private final int max;

        private IntRangeIterable(int max) {
            Preconditions.checkArgument((max >= 0 ? 1 : 0) != 0, (Object)"Max value must be >= 0");
            this.max = max;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new IntRangeIterator(this.max);
        }
    }

    private static class LineIndexToChangeset
    implements Function<Integer, Changeset> {
        private final ScannerReport.Changesets changesets;
        private final Map<Integer, Changeset> changesetCache;
        private final Changeset.Builder builder = Changeset.newChangesetBuilder();

        public LineIndexToChangeset(ScannerReport.Changesets changesets) {
            this.changesets = changesets;
            this.changesetCache = new HashMap<Integer, Changeset>(changesets.getChangesetCount());
        }

        @Nonnull
        public Changeset apply(@Nonnull Integer lineNumber) {
            int changesetIndex = this.changesets.getChangesetIndexByLine(lineNumber - 1);
            Changeset changeset = this.changesetCache.get(changesetIndex);
            if (changeset != null) {
                return changeset;
            }
            Changeset res = this.convert(this.changesets.getChangeset(changesetIndex), lineNumber);
            this.changesetCache.put(changesetIndex, res);
            return res;
        }

        private Changeset convert(ScannerReport.Changesets.Changeset changeset, int line) {
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)changeset.getRevision()), (String)"Changeset on line %s must have a revision", (Object[])new Object[]{line});
            Preconditions.checkState((changeset.getDate() != 0L ? 1 : 0) != 0, (String)"Changeset on line %s must have a date", (Object[])new Object[]{line});
            return this.builder.setRevision(changeset.getRevision()).setAuthor(StringUtils.isNotEmpty((String)changeset.getAuthor()) ? changeset.getAuthor() : null).setDate(changeset.getDate()).build();
        }
    }
}

