/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoImpl;

@Immutable
class DbScmInfo
implements ScmInfo {
    private final ScmInfo delegate;

    private DbScmInfo(ScmInfo delegate) {
        this.delegate = delegate;
    }

    static Optional<ScmInfo> create(Component component, Iterable<DbFileSources.Line> lines) {
        LineToChangeset lineToChangeset = new LineToChangeset();
        List lineChangesets = (List)StreamSupport.stream(lines.spliterator(), false).map(lineToChangeset).filter(Objects::nonNull).collect(MoreCollectors.toList());
        if (lineChangesets.isEmpty()) {
            return Optional.absent();
        }
        Preconditions.checkState((!lineToChangeset.isEncounteredLineWithoutScmInfo() ? 1 : 0) != 0, (String)"Partial scm information stored in DB for component '%s'. Not all lines have SCM info. Can not proceed", (Object[])new Object[]{component});
        return Optional.of((Object)new DbScmInfo(new ScmInfoImpl(lineChangesets)));
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.delegate.getLatestChangeset();
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        return this.delegate.getChangesetForLine(lineNumber);
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return this.delegate.hasChangesetForLine(lineNumber);
    }

    @Override
    public Iterable<Changeset> getAllChangesets() {
        return this.delegate.getAllChangesets();
    }

    private static class LineToChangeset
    implements Function<DbFileSources.Line, Changeset> {
        private boolean encounteredLineWithoutScmInfo = false;
        private final Map<String, Changeset> cache = new HashMap<String, Changeset>();
        private final Changeset.Builder builder = Changeset.newChangesetBuilder();

        private LineToChangeset() {
        }

        @Override
        @Nullable
        public Changeset apply(@Nonnull DbFileSources.Line input) {
            if (input.hasScmRevision() && input.hasScmDate()) {
                String revision = input.getScmRevision();
                return this.cache.computeIfAbsent(revision, k -> this.builder.setRevision(revision).setAuthor(input.hasScmAuthor() ? input.getScmAuthor() : null).setDate(input.getScmDate()).build());
            }
            this.encounteredLineWithoutScmInfo = true;
            return null;
        }

        boolean isEncounteredLineWithoutScmInfo() {
            return this.encounteredLineWithoutScmInfo;
        }
    }
}

