/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitymodel;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.sonar.api.utils.MessageException;

public class RatingGrid {
    private final double[] gridValues;

    RatingGrid(double[] gridValues) {
        this.gridValues = Arrays.copyOf(gridValues, gridValues.length);
    }

    Rating getRatingForDensity(double density) {
        for (Rating rating : Rating.values()) {
            double lowerBound = this.getGradeLowerBound(rating);
            if (!(density >= lowerBound)) continue;
            return rating;
        }
        throw MessageException.of((String)("The rating density value should be between 0 and 1.7976931348623157E308 and got " + density));
    }

    double getGradeLowerBound(Rating rating) {
        if (rating.getIndex() > 1) {
            return this.gridValues[rating.getIndex() - 2];
        }
        return 0.0;
    }

    @VisibleForTesting
    double[] getGridValues() {
        return this.gridValues;
    }

    public static enum Rating {
        E(5),
        D(4),
        C(3),
        B(2),
        A(1);

        private final int index;

        private Rating(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static Rating valueOf(int index) {
            return Arrays.stream(Rating.values()).filter(r -> r.getIndex() == index).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown value '%s'", index)));
        }

        public static boolean isValidRating(String value) {
            return Arrays.stream(Rating.values()).anyMatch(r -> r.name().equals(value));
        }
    }
}

