/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Objects;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateService;
import org.sonar.server.qualitygate.ShortLivingBranchQualityGate;

public class QualityGateServiceImpl
implements QualityGateService {
    private final DbClient dbClient;
    private final MetricRepository metricRepository;

    public QualityGateServiceImpl(DbClient dbClient, MetricRepository metricRepository) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
    }

    @Override
    public Optional<QualityGate> findById(long id) {
        if (id == -1963456987L) {
            return Optional.of((Object)this.buildShortLivingBranchHardcodedQualityGate());
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto qualityGateDto = this.dbClient.qualityGateDao().selectById(dbSession, id);
            if (qualityGateDto == null) {
                Optional optional = Optional.absent();
                return optional;
            }
            Optional optional = Optional.of((Object)this.toQualityGate(dbSession, qualityGateDto));
            return optional;
        }
    }

    private QualityGate toQualityGate(DbSession dbSession, QualityGateDto qualityGateDto) {
        Collection dtos = this.dbClient.gateConditionDao().selectForQualityGate(dbSession, qualityGateDto.getId().longValue());
        Iterable conditions = (Iterable)dtos.stream().map(input -> this.metricRepository.getOptionalById(input.getMetricId()).map(metric -> new Condition((Metric)metric, input.getOperator(), input.getErrorThreshold(), input.getWarningThreshold(), input.getPeriod() != null)).orElse(null)).filter(Objects::nonNull).collect(MoreCollectors.toList((int)dtos.size()));
        return new QualityGate(qualityGateDto.getId(), qualityGateDto.getName(), conditions);
    }

    private QualityGate buildShortLivingBranchHardcodedQualityGate() {
        return new QualityGate(-1963456987L, "Hardcoded short living branch quality gate", (Iterable)ShortLivingBranchQualityGate.CONDITIONS.stream().map(c -> new Condition(this.metricRepository.getByKey(c.getMetricKey()), c.getOperator(), c.getErrorThreshold(), c.getWarnThreshold(), c.isOnLeak())).collect(MoreCollectors.toList((int)ShortLivingBranchQualityGate.CONDITIONS.size())));
    }
}

