/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LazyInput;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.protobuf.DbCommons;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.issue.commonrule.CommonRuleEngine;
import org.sonar.server.computation.task.projectanalysis.issue.filter.IssueFilter;
import org.sonar.server.computation.task.projectanalysis.source.SourceLinesRepository;

public class TrackerRawInputFactory {
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private final SourceLinesRepository sourceLinesRepository;
    private final CommonRuleEngine commonRuleEngine;
    private final IssueFilter issueFilter;

    public TrackerRawInputFactory(TreeRootHolder treeRootHolder, BatchReportReader reportReader, SourceLinesRepository sourceLinesRepository, CommonRuleEngine commonRuleEngine, IssueFilter issueFilter) {
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
        this.sourceLinesRepository = sourceLinesRepository;
        this.commonRuleEngine = commonRuleEngine;
        this.issueFilter = issueFilter;
    }

    public Input<DefaultIssue> create(Component component) {
        return new RawLazyInput(component);
    }

    private class RawLazyInput
    extends LazyInput<DefaultIssue> {
        private final Component component;

        private RawLazyInput(Component component) {
            this.component = component;
        }

        protected LineHashSequence loadLineHashSequence() {
            ArrayList lines;
            if (this.component.getType() == Component.Type.FILE) {
                try (CloseableIterator<String> linesIt = TrackerRawInputFactory.this.sourceLinesRepository.readLines(this.component);){
                    lines = Lists.newArrayList(linesIt);
                }
            } else {
                lines = Collections.emptyList();
            }
            return LineHashSequence.createForLines(lines);
        }

        protected List<DefaultIssue> loadIssues() {
            ArrayList<DefaultIssue> result = new ArrayList<DefaultIssue>();
            for (DefaultIssue commonRuleIssue : TrackerRawInputFactory.this.commonRuleEngine.process(this.component)) {
                if (!TrackerRawInputFactory.this.issueFilter.accept(commonRuleIssue, this.component)) continue;
                result.add(this.init(commonRuleIssue));
            }
            try (CloseableIterator<ScannerReport.Issue> reportIssues = TrackerRawInputFactory.this.reportReader.readComponentIssues(this.component.getReportAttributes().getRef());){
                while (reportIssues.hasNext()) {
                    ScannerReport.Issue reportIssue = (ScannerReport.Issue)reportIssues.next();
                    if (!this.isIssueOnUnsupportedCommonRule(reportIssue)) {
                        Loggers.get(((Object)((Object)this)).getClass()).debug("Ignored issue from analysis report on rule {}:{}", (Object)reportIssue.getRuleRepository(), (Object)reportIssue.getRuleKey());
                        continue;
                    }
                    DefaultIssue issue = this.toIssue(this.getLineHashSequence(), reportIssue);
                    if (!TrackerRawInputFactory.this.issueFilter.accept(issue, this.component)) continue;
                    result.add(issue);
                }
            }
            return result;
        }

        private boolean isIssueOnUnsupportedCommonRule(ScannerReport.Issue issue) {
            return !issue.getRuleRepository().startsWith("common-");
        }

        private DefaultIssue toIssue(LineHashSequence lineHashSeq, ScannerReport.Issue reportIssue) {
            DefaultIssue issue = new DefaultIssue();
            this.init(issue);
            issue.setRuleKey(RuleKey.of((String)reportIssue.getRuleRepository(), (String)reportIssue.getRuleKey()));
            if (reportIssue.hasTextRange()) {
                int startLine = reportIssue.getTextRange().getStartLine();
                issue.setLine(Integer.valueOf(startLine));
                issue.setChecksum(lineHashSeq.getHashForLine(startLine));
            } else {
                issue.setChecksum("");
            }
            if (StringUtils.isNotEmpty((String)reportIssue.getMsg())) {
                issue.setMessage(reportIssue.getMsg());
            }
            if (reportIssue.getSeverity() != Constants.Severity.UNSET_SEVERITY) {
                issue.setSeverity(reportIssue.getSeverity().name());
            }
            if (reportIssue.getGap() != 0.0) {
                issue.setGap(Double.valueOf(reportIssue.getGap()));
            }
            DbIssues.Locations.Builder dbLocationsBuilder = DbIssues.Locations.newBuilder();
            if (reportIssue.hasTextRange()) {
                dbLocationsBuilder.setTextRange(this.convertTextRange(reportIssue.getTextRange()));
            }
            for (ScannerReport.Flow flow : reportIssue.getFlowList()) {
                if (flow.getLocationCount() <= 0) continue;
                DbIssues.Flow.Builder dbFlowBuilder = DbIssues.Flow.newBuilder();
                for (ScannerReport.IssueLocation location : flow.getLocationList()) {
                    dbFlowBuilder.addLocation(this.convertLocation(location));
                }
                dbLocationsBuilder.addFlow(dbFlowBuilder);
            }
            issue.setLocations((Object)dbLocationsBuilder.build());
            return issue;
        }

        private DefaultIssue init(DefaultIssue issue) {
            issue.setResolution(null);
            issue.setStatus("OPEN");
            issue.setComponentUuid(this.component.getUuid());
            issue.setComponentKey(this.component.getPublicKey());
            issue.setProjectUuid(TrackerRawInputFactory.this.treeRootHolder.getRoot().getUuid());
            issue.setProjectKey(TrackerRawInputFactory.this.treeRootHolder.getRoot().getPublicKey());
            return issue;
        }

        private DbIssues.Location convertLocation(ScannerReport.IssueLocation source) {
            DbIssues.Location.Builder target = DbIssues.Location.newBuilder();
            if (source.getComponentRef() != 0 && source.getComponentRef() != this.component.getReportAttributes().getRef()) {
                target.setComponentId(TrackerRawInputFactory.this.treeRootHolder.getComponentByRef(source.getComponentRef()).getUuid());
            }
            if (StringUtils.isNotEmpty((String)source.getMsg())) {
                target.setMsg(source.getMsg());
            }
            if (source.hasTextRange()) {
                ScannerReport.TextRange sourceRange = source.getTextRange();
                DbCommons.TextRange.Builder targetRange = this.convertTextRange(sourceRange);
                target.setTextRange(targetRange);
            }
            return target.build();
        }

        private DbCommons.TextRange.Builder convertTextRange(ScannerReport.TextRange sourceRange) {
            DbCommons.TextRange.Builder targetRange = DbCommons.TextRange.newBuilder();
            targetRange.setStartLine(sourceRange.getStartLine());
            targetRange.setStartOffset(sourceRange.getStartOffset());
            targetRange.setEndLine(sourceRange.getEndLine());
            targetRange.setEndOffset(sourceRange.getEndOffset());
            return targetRange;
        }
    }
}

